/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.preview;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.digest.DigestUtils;
import org.gephi.preview.api.PreviewPreset;
import org.gephi.preview.api.PreviewProperties;
import org.gephi.preview.presets.DefaultPreset;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PresetUtils {
    private List<PreviewPreset> presets;

    public void savePreset(PreviewPreset preset) {
        int exist = -1;
        for (int i = 0; i < this.presets.size(); ++i) {
            PreviewPreset p = this.presets.get(i);
            if (!p.getName().equals(preset.getName())) continue;
            exist = i;
            break;
        }
        if (exist == -1) {
            this.addPreset(preset);
        } else {
            this.presets.set(exist, preset);
        }
        try {
            String filename;
            FileObject presetFile;
            FileObject folder = FileUtil.getConfigFile((String)"previewpresets");
            if (folder == null) {
                folder = FileUtil.getConfigRoot().createFolder("previewpresets");
            }
            if ((presetFile = folder.getFileObject(filename = DigestUtils.sha1Hex((String)preset.getName()), "xml")) == null) {
                presetFile = folder.createData(filename, "xml");
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            document.setXmlVersion("1.0");
            document.setXmlStandalone(true);
            this.writeXML(document, preset);
            try (OutputStream outputStream = presetFile.getOutputStream();){
                DOMSource source = new DOMSource(document);
                StreamResult result = new StreamResult(outputStream);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.transform(source, result);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public PreviewPreset[] getPresets() {
        if (this.presets == null) {
            this.presets = new ArrayList<PreviewPreset>();
            this.loadPresets();
        }
        return this.presets.toArray(new PreviewPreset[0]);
    }

    private void loadPresets() {
        FileObject folder = FileUtil.getConfigFile((String)"previewpresets");
        if (folder != null) {
            for (FileObject child : folder.getChildren()) {
                if (!child.isValid() || !child.hasExt("xml")) continue;
                try (InputStream stream = child.getInputStream();){
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document document = builder.parse(stream);
                    PreviewPreset preset = this.readXML(document);
                    this.addPreset(preset);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void writeXML(Document doc, PreviewPreset preset) {
        Element presetE = doc.createElement("previewpreset");
        presetE.setAttribute("name", preset.getName());
        presetE.setAttribute("version", "0.8.1");
        for (Map.Entry entry : preset.getProperties().entrySet()) {
            String propertyName = (String)entry.getKey();
            try {
                String serialized;
                Object propertyValue = entry.getValue();
                if (propertyValue == null || (serialized = PreviewProperties.getValueAsText(propertyValue)) == null) continue;
                Element propertyE = doc.createElement("previewproperty");
                propertyE.setAttribute("name", propertyName);
                propertyE.setAttribute("class", propertyValue.getClass().getName());
                propertyE.setTextContent(serialized);
                presetE.appendChild(propertyE);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        doc.appendChild(presetE);
    }

    private PreviewPreset readXML(Document document) {
        DefaultPreset defaultPreset = new DefaultPreset();
        Element presetE = document.getDocumentElement();
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        String presetName = presetE.getAttribute("name");
        NodeList propertyList = presetE.getElementsByTagName("previewproperty");
        for (int i = 0; i < propertyList.getLength(); ++i) {
            Object value;
            Node n = propertyList.item(i);
            if (n.getNodeType() != 1) continue;
            Element propertyE = (Element)n;
            String name = propertyE.getAttribute("name");
            String valueClassName = propertyE.hasAttribute(name) ? propertyE.getAttribute("class") : null;
            String stringValue = propertyE.getTextContent();
            Class<?> valueClass = null;
            if (valueClassName != null) {
                try {
                    valueClass = Class.forName(valueClassName);
                }
                catch (ClassNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                Object defaultValue = defaultPreset.getProperties().get(name);
                if (defaultValue != null) {
                    valueClass = defaultValue.getClass();
                }
            }
            if (valueClass == null || (value = PreviewProperties.readValueFromText((String)stringValue, valueClass)) == null) continue;
            propertiesMap.put(name, value);
        }
        return new PreviewPreset(presetName, propertiesMap);
    }

    protected void addPreset(PreviewPreset preset) {
        this.presets.add(preset);
    }
}

