import { IrcHandler } from "./IrcHandler";
import { MatrixHandler } from "./MatrixHandler";
import { MemberListSyncer } from "./MemberListSyncer";
import { IrcServer } from "../irc/IrcServer";
import { ClientPool } from "../irc/ClientPool";
import { BridgedClient } from "../irc/BridgedClient";
import { IrcUser } from "../models/IrcUser";
import { IrcRoom } from "../models/IrcRoom";
import { BridgeRequest, BridgeRequestEvent } from "../models/BridgeRequest";
import { Provisioner } from "../provisioning/Provisioner";
import { PublicitySyncer } from "./PublicitySyncer";
import { Histogram } from "prom-client";
import { AppServiceRegistration } from "matrix-appservice";
import { Bridge, MatrixUser, MatrixRoom, BridgeInfoStateSyncer, ActivityTracker, MediaProxy } from "matrix-appservice-bridge";
import { IrcAction } from "../models/IrcAction";
import { DataStore } from "../datastore/DataStore";
import { MatrixAction } from "../models/MatrixAction";
import { BridgeConfig } from "../config/BridgeConfig";
import { RoomConfig } from "./RoomConfig";
import { TestingOptions } from "../config/TestOpts";
import { MatrixBanSync } from "./MatrixBanSync";
export declare const MEMBERSHIP_DEFAULT_TTL: number;
export declare const METRIC_ACTIVE_USERS = "active_users";
type Timers = {
    matrix_request_seconds: Histogram<string>;
    remote_request_seconds: Histogram<string>;
    irc_connection_time_ms: Histogram<string>;
};
export declare class IrcBridge {
    readonly config: BridgeConfig;
    private registration;
    private readonly testOpts;
    static readonly DEFAULT_LOCALPART = "appservice-irc";
    onAliasQueried: (() => void) | null;
    readonly matrixHandler: MatrixHandler;
    readonly ircHandler: IrcHandler;
    readonly publicitySyncer: PublicitySyncer;
    activityTracker: ActivityTracker | null;
    readonly roomConfigs: RoomConfig;
    readonly matrixBanSyncer?: MatrixBanSync;
    private _mediaProxy?;
    private clientPool;
    private ircServers;
    private memberListSyncers;
    private joinedRoomList;
    private dataStore;
    private bridgeState;
    private debugApi;
    private provisioner;
    private bridge;
    private appservice;
    private timers;
    private membershipCache;
    private readonly membershipQueue;
    private bridgeStateSyncer?;
    private privacyProtection;
    private bridgeBlocker?;
    private ircPoolClient?;
    constructor(config: BridgeConfig, registration: AppServiceRegistration, testOpts?: TestingOptions);
    onConfigChanged(newConfig: BridgeConfig): Promise<void>;
    private initialiseMediaProxy;
    private initialiseMetrics;
    get appServiceUserId(): string;
    get mediaProxy(): MediaProxy;
    getStore(): DataStore;
    getAppServiceBridge(): Bridge;
    getClientPool(): ClientPool;
    getProvisioner(): Provisioner;
    get domain(): string;
    get stateSyncer(): BridgeInfoStateSyncer<{
        channel: string;
        networkId: string;
    }> | undefined;
    private pingBridge;
    createInfoMapping(channel: string, networkId: string): {
        protocol: {
            id: string;
            displayname: string;
        };
        network: {
            id: string;
            displayname: string | undefined;
            avatar_url: `mxc://`;
        };
        channel: {
            id: string;
        };
    };
    run(port: number | null): Promise<void>;
    private setupStateSyncer;
    private logMetric;
    logTime(key: keyof Timers, time: number): void;
    private addRequestCallbacks;
    kill(reason?: string): Promise<void>;
    get isStartedUp(): boolean;
    private joinMappedMatrixRooms;
    sendMatrixAction(room: MatrixRoom, from: MatrixUser | undefined, action: MatrixAction): Promise<void>;
    syncMembersInRoomToIrc(req: BridgeRequest, roomId: string, ircRoom: IrcRoom, kickFailures?: boolean): Promise<void>;
    uploadTextFile(fileName: string, plaintext: string): Promise<string>;
    getMatrixUser(ircUser: IrcUser): Promise<MatrixUser>;
    onEvent(request: BridgeRequestEvent): void;
    private onEphemeralEvent;
    private _onEvent;
    onUserQuery(matrixUser: MatrixUser): Promise<null>;
    onAliasQuery(alias: string): Promise<null>;
    private onLog;
    getThirdPartyProtocol(): Promise<{
        user_fields: string[];
        location_fields: string[];
        field_types: {
            domain: {
                regexp: string;
                placeholder: string;
            };
            nick: {
                regexp: string;
                placeholder: string;
            };
            channel: {
                regexp: string;
                placeholder: string;
            };
        };
        icon: string;
        instances: {
            network_id: string;
            bot_user_id: string;
            desc: string;
            icon: string | undefined;
            fields: {
                domain: string;
            };
        }[];
    }>;
    getThirdPartyLocation(protocol: string, fields: {
        domain?: string;
        channel?: string;
    }): Promise<{
        alias: string;
        protocol: string;
        fields: {
            domain: string;
            channel: string;
        };
    }[]>;
    getThirdPartyUser(protocol: string, fields: {
        domain?: string;
        nick?: string;
    }): Promise<{
        userid: string;
        protocol: string;
        fields: {
            domain: string;
            nick: string;
        };
    }[]>;
    getIrcUserFromCache(server: IrcServer, userId: string): BridgedClient | undefined;
    getBridgedClientsForUserId(userId: string): BridgedClient[];
    getBridgedClientsForRegex(regex: string): {
        [userId: string]: BridgedClient[];
    };
    getBridgedClient(server: IrcServer, userId: string, displayName?: string): Promise<BridgedClient>;
    getServer(domainName: string): IrcServer | null;
    getServers(): IrcServer[];
    getMemberListSyncer(server: IrcServer): MemberListSyncer;
    aliasToIrcChannel(alias: string): {
        server?: undefined;
        channel?: undefined;
    } | {
        server: IrcServer;
        channel: string | null;
    };
    getServerForUserId(userId: string): IrcServer | null;
    matrixToIrcUser(user: MatrixUser): Promise<IrcUser>;
    connectToIrcNetworks(): Promise<void>;
    /**
     * Determines if a nick name already exists.
     */
    checkNickExists(server: IrcServer, nick: string): Promise<boolean>;
    joinBot(ircRoom: IrcRoom): Promise<void>;
    partBot(ircRoom: IrcRoom): Promise<void>;
    sendIrcAction(ircRoom: IrcRoom, bridgedClient: BridgedClient, action: IrcAction): Promise<void>;
    getBotClient(server: IrcServer): Promise<BridgedClient>;
    private fetchJoinedRooms;
    private onRoomUpgrade;
    /**
     * Calculate the number of idle users
     * @param server The IRC server which we want to scope the idle check to.
     * @param minIdleHours The minimum number of hours to be considered idle.
     * @param defaultOnline Whether the user should be defaulted to online or offline if we hold no data for them.
     * @param excludeRegex A regex of users to exclude from the check.
     * @param maxIdleHours The maximum number of hours to be considered
     *                     idle before they aren't considered part of the pool. By default, this isn't checked.
     * @returns An ordered array of userIds by their idle time in ascending order.
     */
    private calculateIdlenessPool;
    /**
     * Warn users that they are in danger of being reaped from a room.
     * @param serverName The name of the IRC server which we want to scope the idle check to.
     * @param maxIdleHours The maximum number of hours a user can be considered idle for.
     * @param msg A message to send to affected idle users.
     * @param defaultOnline Whether the user should be defaulted to online or offline if we hold no data for them.
     * @param excludeRegex A regex of users to exclude from the check.
     */
    warnConnectionReap(req: BridgeRequest, serverName: string, minIdleHours: number, msg: string, defaultOnline?: boolean, excludeRegex?: string, limit?: number): Promise<void>;
    connectionReap(logCb: (line: string) => void, reqServerName: string, maxIdleHours: number, reason?: string, dry?: boolean, defaultOnline?: boolean, excludeRegex?: string, limit?: number): Promise<void>;
    atBridgedRoomLimit(): Promise<boolean>;
    private onUserActivityChanged;
}
export {};
