/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client;

import java.util.Iterator;
import org.opensearch.client.Node;

public interface NodeSelector {
    public static final NodeSelector ANY = new NodeSelector(){

        @Override
        public void select(Iterable<Node> nodes) {
        }

        public String toString() {
            return "ANY";
        }
    };
    public static final NodeSelector SKIP_DEDICATED_CLUSTER_MANAGERS = new NodeSelector(){

        @Override
        public void select(Iterable<Node> nodes) {
            Iterator<Node> itr = nodes.iterator();
            while (itr.hasNext()) {
                Node node = itr.next();
                if (node.getRoles() == null || !node.getRoles().isClusterManagerEligible() || node.getRoles().isData() || node.getRoles().isIngest()) continue;
                itr.remove();
            }
        }

        public String toString() {
            return "SKIP_DEDICATED_CLUSTER_MANAGERS";
        }
    };

    public void select(Iterable<Node> var1);
}

