/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.resolver.Blame;
import org.apache.felix.resolver.Util;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

class UsedBlames {
    public final Set<Capability> m_caps;
    public final List<Blame> m_blames = new ArrayList<Blame>();
    private Map<Requirement, Set<Capability>> m_rootCauses;

    public UsedBlames(Set<Capability> caps) {
        this.m_caps = caps;
    }

    public void addBlame(Blame blame, Capability matchingRootCause) {
        Requirement req;
        if (!this.m_caps.contains(blame.m_cap)) {
            throw new IllegalArgumentException("Attempt to add a blame with a different used capability: " + blame.m_cap);
        }
        this.m_blames.add(blame);
        if (matchingRootCause != null && Util.isMultiple(req = blame.m_reqs.get(0))) {
            Set<Capability> rootCauses;
            if (this.m_rootCauses == null) {
                this.m_rootCauses = new HashMap<Requirement, Set<Capability>>();
            }
            if ((rootCauses = this.m_rootCauses.get(req)) == null) {
                rootCauses = new HashSet<Capability>();
                this.m_rootCauses.put(req, rootCauses);
            }
            rootCauses.add(matchingRootCause);
        }
    }

    public Set<Capability> getRootCauses(Requirement req) {
        if (this.m_rootCauses == null) {
            return Collections.emptySet();
        }
        Set<Capability> result = this.m_rootCauses.get(req);
        return result == null ? Collections.emptySet() : result;
    }

    public String toString() {
        return this.m_blames.toString();
    }
}

