/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.valid;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.valid.IndexedNestedHoleTester;
import org.locationtech.jts.operation.valid.IndexedNestedPolygonTester;
import org.locationtech.jts.operation.valid.PolygonTopologyAnalyzer;
import org.locationtech.jts.operation.valid.TopologyValidationError;

public class IsValidOp {
    private static final int MIN_SIZE_LINESTRING = 2;
    private static final int MIN_SIZE_RING = 4;
    private Geometry inputGeometry;
    private boolean isInvertedRingValid = false;
    private TopologyValidationError validErr;

    public static boolean isValid(Geometry geom) {
        IsValidOp isValidOp = new IsValidOp(geom);
        return isValidOp.isValid();
    }

    public static boolean isValid(Coordinate coord) {
        if (Double.isNaN(coord.x)) {
            return false;
        }
        if (Double.isInfinite(coord.x)) {
            return false;
        }
        if (Double.isNaN(coord.y)) {
            return false;
        }
        return !Double.isInfinite(coord.y);
    }

    public IsValidOp(Geometry inputGeometry) {
        this.inputGeometry = inputGeometry;
    }

    public void setSelfTouchingRingFormingHoleValid(boolean isValid) {
        this.isInvertedRingValid = isValid;
    }

    public boolean isValid() {
        return this.isValidGeometry(this.inputGeometry);
    }

    public TopologyValidationError getValidationError() {
        this.isValidGeometry(this.inputGeometry);
        return this.validErr;
    }

    private void logInvalid(int code, Coordinate pt) {
        this.validErr = new TopologyValidationError(code, pt);
    }

    private boolean hasInvalidError() {
        return this.validErr != null;
    }

    private boolean isValidGeometry(Geometry g) {
        this.validErr = null;
        if (g.isEmpty()) {
            return true;
        }
        if (g instanceof Point) {
            return this.isValid((Point)g);
        }
        if (g instanceof MultiPoint) {
            return this.isValid((MultiPoint)g);
        }
        if (g instanceof LinearRing) {
            return this.isValid((LinearRing)g);
        }
        if (g instanceof LineString) {
            return this.isValid((LineString)g);
        }
        if (g instanceof Polygon) {
            return this.isValid((Polygon)g);
        }
        if (g instanceof MultiPolygon) {
            return this.isValid((MultiPolygon)g);
        }
        if (g instanceof GeometryCollection) {
            return this.isValid((GeometryCollection)g);
        }
        throw new UnsupportedOperationException(g.getClass().getName());
    }

    private boolean isValid(Point g) {
        this.checkCoordinatesValid(g.getCoordinates());
        return !this.hasInvalidError();
    }

    private boolean isValid(MultiPoint g) {
        this.checkCoordinatesValid(g.getCoordinates());
        return !this.hasInvalidError();
    }

    private boolean isValid(LineString g) {
        this.checkCoordinatesValid(g.getCoordinates());
        if (this.hasInvalidError()) {
            return false;
        }
        this.checkPointSize(g, 2);
        return !this.hasInvalidError();
    }

    private boolean isValid(LinearRing g) {
        this.checkCoordinatesValid(g.getCoordinates());
        if (this.hasInvalidError()) {
            return false;
        }
        this.checkRingClosed(g);
        if (this.hasInvalidError()) {
            return false;
        }
        this.checkRingPointSize(g);
        if (this.hasInvalidError()) {
            return false;
        }
        this.checkRingSimple(g);
        return this.validErr == null;
    }

    private boolean isValid(Polygon g) {
        this.checkCoordinatesValid(g);
        if (this.hasInvalidError()) {
            return false;
        }
        this.checkRingsClosed(g);
        if (this.hasInvalidError()) {
            return false;
        }
        this.checkRingsPointSize(g);
        if (this.hasInvalidError()) {
            return false;
        }
        PolygonTopologyAnalyzer areaAnalyzer = new PolygonTopologyAnalyzer(g, this.isInvertedRingValid);
        this.checkAreaIntersections(areaAnalyzer);
        if (this.hasInvalidError()) {
            return false;
        }
        this.checkHolesInShell(g);
        if (this.hasInvalidError()) {
            return false;
        }
        this.checkHolesNotNested(g);
        if (this.hasInvalidError()) {
            return false;
        }
        this.checkInteriorConnected(areaAnalyzer);
        return !this.hasInvalidError();
    }

    private boolean isValid(MultiPolygon g) {
        Polygon p;
        int i;
        for (int i2 = 0; i2 < g.getNumGeometries(); ++i2) {
            Polygon p2 = (Polygon)g.getGeometryN(i2);
            this.checkCoordinatesValid(p2);
            if (this.hasInvalidError()) {
                return false;
            }
            this.checkRingsClosed(p2);
            if (this.hasInvalidError()) {
                return false;
            }
            this.checkRingsPointSize(p2);
            if (!this.hasInvalidError()) continue;
            return false;
        }
        PolygonTopologyAnalyzer areaAnalyzer = new PolygonTopologyAnalyzer(g, this.isInvertedRingValid);
        this.checkAreaIntersections(areaAnalyzer);
        if (this.hasInvalidError()) {
            return false;
        }
        for (i = 0; i < g.getNumGeometries(); ++i) {
            p = (Polygon)g.getGeometryN(i);
            this.checkHolesInShell(p);
            if (!this.hasInvalidError()) continue;
            return false;
        }
        for (i = 0; i < g.getNumGeometries(); ++i) {
            p = (Polygon)g.getGeometryN(i);
            this.checkHolesNotNested(p);
            if (!this.hasInvalidError()) continue;
            return false;
        }
        this.checkShellsNotNested(g);
        if (this.hasInvalidError()) {
            return false;
        }
        this.checkInteriorConnected(areaAnalyzer);
        return !this.hasInvalidError();
    }

    private boolean isValid(GeometryCollection gc) {
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            if (this.isValidGeometry(gc.getGeometryN(i))) continue;
            return false;
        }
        return true;
    }

    private void checkCoordinatesValid(Coordinate[] coords) {
        for (int i = 0; i < coords.length; ++i) {
            if (IsValidOp.isValid(coords[i])) continue;
            this.logInvalid(10, coords[i]);
            return;
        }
    }

    private void checkCoordinatesValid(Polygon poly) {
        this.checkCoordinatesValid(poly.getExteriorRing().getCoordinates());
        if (this.hasInvalidError()) {
            return;
        }
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            this.checkCoordinatesValid(poly.getInteriorRingN(i).getCoordinates());
            if (!this.hasInvalidError()) continue;
            return;
        }
    }

    private void checkRingClosed(LinearRing ring) {
        if (ring.isEmpty()) {
            return;
        }
        if (!ring.isClosed()) {
            Coordinate pt = ring.getNumPoints() >= 1 ? ring.getCoordinateN(0) : null;
            this.logInvalid(11, pt);
            return;
        }
    }

    private void checkRingsClosed(Polygon poly) {
        this.checkRingClosed(poly.getExteriorRing());
        if (this.hasInvalidError()) {
            return;
        }
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            this.checkRingClosed(poly.getInteriorRingN(i));
            if (!this.hasInvalidError()) continue;
            return;
        }
    }

    private void checkRingsPointSize(Polygon poly) {
        this.checkRingPointSize(poly.getExteriorRing());
        if (this.hasInvalidError()) {
            return;
        }
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            this.checkRingPointSize(poly.getInteriorRingN(i));
            if (!this.hasInvalidError()) continue;
            return;
        }
    }

    private void checkRingPointSize(LinearRing ring) {
        if (ring.isEmpty()) {
            return;
        }
        this.checkPointSize(ring, 4);
    }

    private void checkPointSize(LineString line, int minSize) {
        if (!this.isNonRepeatedSizeAtLeast(line, minSize)) {
            Coordinate pt = line.getNumPoints() >= 1 ? line.getCoordinateN(0) : null;
            this.logInvalid(9, pt);
        }
    }

    private boolean isNonRepeatedSizeAtLeast(LineString line, int minSize) {
        int numPts = 0;
        Coordinate prevPt = null;
        for (int i = 0; i < line.getNumPoints(); ++i) {
            if (numPts >= minSize) {
                return true;
            }
            Coordinate pt = line.getCoordinateN(i);
            if (prevPt == null || !pt.equals2D(prevPt)) {
                ++numPts;
            }
            prevPt = pt;
        }
        return numPts >= minSize;
    }

    private void checkAreaIntersections(PolygonTopologyAnalyzer areaAnalyzer) {
        if (areaAnalyzer.hasInvalidIntersection()) {
            this.logInvalid(areaAnalyzer.getInvalidCode(), areaAnalyzer.getInvalidLocation());
            return;
        }
    }

    private void checkRingSimple(LinearRing ring) {
        Coordinate intPt = PolygonTopologyAnalyzer.findSelfIntersection(ring);
        if (intPt != null) {
            this.logInvalid(6, intPt);
        }
    }

    private void checkHolesInShell(Polygon poly) {
        if (poly.getNumInteriorRing() <= 0) {
            return;
        }
        LinearRing shell = poly.getExteriorRing();
        boolean isShellEmpty = shell.isEmpty();
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            LinearRing hole = poly.getInteriorRingN(i);
            if (hole.isEmpty()) continue;
            Coordinate invalidPt = null;
            invalidPt = isShellEmpty ? hole.getCoordinate() : this.findHoleOutsideShellPoint(hole, shell);
            if (invalidPt == null) continue;
            this.logInvalid(2, invalidPt);
            return;
        }
    }

    private Coordinate findHoleOutsideShellPoint(LinearRing hole, LinearRing shell) {
        Coordinate holePt0 = hole.getCoordinateN(0);
        if (!shell.getEnvelopeInternal().covers(hole.getEnvelopeInternal())) {
            return holePt0;
        }
        if (PolygonTopologyAnalyzer.isRingNested(hole, shell)) {
            return null;
        }
        return holePt0;
    }

    private void checkHolesNotNested(Polygon poly) {
        if (poly.getNumInteriorRing() <= 0) {
            return;
        }
        IndexedNestedHoleTester nestedTester = new IndexedNestedHoleTester(poly);
        if (nestedTester.isNested()) {
            this.logInvalid(3, nestedTester.getNestedPoint());
        }
    }

    private void checkShellsNotNested(MultiPolygon mp) {
        if (mp.getNumGeometries() <= 1) {
            return;
        }
        IndexedNestedPolygonTester nestedTester = new IndexedNestedPolygonTester(mp);
        if (nestedTester.isNested()) {
            this.logInvalid(7, nestedTester.getNestedPoint());
        }
    }

    private void checkInteriorConnected(PolygonTopologyAnalyzer analyzer) {
        if (analyzer.isInteriorDisconnected()) {
            this.logInvalid(4, analyzer.getDisconnectionLocation());
        }
    }
}

