/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.tasks;

import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.db2.model.DB2TableBase;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.sql.task.SQLToolExecuteSettings;

public class DB2ReorgIndexToolSettings
extends SQLToolExecuteSettings<DB2TableBase> {
    private static final String[] tableAccesses = new String[]{"", " ALLOW NO ACCESS", " ALLOW READ ACCESS", " ALLOW WRITE ACCESS"};
    private static final String[] cleanupOptions = new String[]{"", " CLEANUP ALL", " CLEANUP PAGES"};
    private String tableAccess;
    private String cleanupOption;

    @Property(viewable=true, editable=true, updatable=true, order=1, listProvider=CheckStorageOptionListProvider.class)
    public String getTableAccess() {
        if (this.tableAccess == null) {
            this.tableAccess = tableAccesses[0];
        }
        return this.tableAccess;
    }

    public void setTableAccess(String tableAccess) {
        this.tableAccess = tableAccess;
    }

    @Property(viewable=true, editable=true, updatable=true, order=2, listProvider=CheckTriggersOptionListProvider.class)
    public String getCleanupOption() {
        if (this.cleanupOption == null) {
            this.cleanupOption = cleanupOptions[0];
        }
        return this.cleanupOption;
    }

    public void setCleanupOption(String storageOption) {
        this.cleanupOption = storageOption;
    }

    public void loadConfiguration(@NotNull DBRRunnableContext runnableContext, @NotNull Map<String, Object> config, @NotNull DBPProject project) {
        super.loadConfiguration(runnableContext, config, project);
        this.tableAccess = JSONUtils.getString(config, (String)"table_access");
        this.cleanupOption = JSONUtils.getString(config, (String)"option");
    }

    public void saveConfiguration(Map<String, Object> config) {
        super.saveConfiguration(config);
        config.put("table_access", this.tableAccess);
        config.put("option", this.cleanupOption);
    }

    public static class CheckStorageOptionListProvider
    implements IPropertyValueListProvider<DB2ReorgIndexToolSettings> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(DB2ReorgIndexToolSettings object) {
            return tableAccesses;
        }
    }

    public static class CheckTriggersOptionListProvider
    implements IPropertyValueListProvider<DB2ReorgIndexToolSettings> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(DB2ReorgIndexToolSettings object) {
            return cleanupOptions;
        }
    }
}

