/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.data;

import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;

public class QueryTransformerRowNum
implements DBCQueryTransformer {
    private static final Log log = Log.getLog(QueryTransformerRowNum.class);
    private Number offset;
    private Number length;

    public void setParameters(Object ... parameters) {
        this.offset = (Number)parameters[0];
        this.length = (Number)parameters[1];
    }

    public String transformQueryString(SQLQuery query) throws DBCException {
        long totalRows = this.offset.longValue() + this.length.longValue();
        if (query.isPlainSelect()) {
            try {
                Statement statement = query.getStatement();
                if (statement instanceof PlainSelect) {
                    PlainSelect select = (PlainSelect)statement;
                    SQLSemanticProcessor.addWhereToSelect((PlainSelect)select, (String)("ROWNUM <= " + totalRows));
                    return statement.toString();
                }
            }
            catch (Throwable e) {
                log.debug((Object)e);
            }
        }
        return query.getText();
    }

    public void transformStatement(DBCStatement statement, int parameterIndex) throws DBCException {
        statement.setLimit(this.offset.longValue(), this.length.longValue());
    }
}

