/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.jobs;

import java.util.Collection;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.DBeaverNotifications;
import org.jkiss.dbeaver.runtime.jobs.InvalidateJob;

public class DefaultInvalidationFeedbackHandler
implements InvalidateJob.InvalidationFeedbackHandler {
    @Override
    public boolean confirmInvalidate(@NotNull Set<DBPDataSourceContainer> containersToInvalidate) {
        return true;
    }

    @Override
    public void onInvalidateSuccess(@NotNull DBPDataSourceContainer container, @NotNull Collection<InvalidateJob.ContextInvalidateResult> results) {
        DBeaverNotifications.showNotification(container.getDataSource(), "reconnect.success", "Datasource was invalidated\n\nLive connection count: " + InvalidateJob.getSucceededCount(results) + "/" + results.size(), DBPMessageType.INFORMATION);
    }

    @Override
    public void onInvalidateFailure(@NotNull DBPDataSourceContainer container, @NotNull Collection<InvalidateJob.ContextInvalidateResult> results) {
        DBeaverNotifications.showNotification(container.getDataSource(), "reconnect.failure", "Datasource invalidate failed", DBPMessageType.ERROR, () -> this.onNotificationFeedback(container));
    }

    protected void onNotificationFeedback(@NotNull DBPDataSourceContainer container) {
        DBWorkbench.getPlatformUI().openConnectionEditor(container);
    }
}

