/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.iotdb.model.meta;

import java.sql.SQLException;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class IoTDBTableMetaModel
extends GenericMetaModel {
    private static final Log log = Log.getLog(IoTDBTableMetaModel.class);
    private static final String[] allIotdbTableSQLKeywords = new String[]{"ALTER", "AND", "AS", "BETWEEN", "BY", "CASE", "CAST", "CONSTRAINT", "CREATE", "CROSS", "CUBE", "CURRENT_CATALOG", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_SCHEMA", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DEALLOCATE", "DELETE", "DESCRIBE", "DISTINCT", "DROP", "ELSE", "END", "ESCAPE", "EXCEPT", "EXISTS", "EXTRACT", "FALSE", "FOR", "FROM", "FULL", "GROUP", "GROUPING", "HAVING", "IN", "INNER", "INSERT", "INTERSECT", "INTO", "IS", "JOIN", "JSON_ARRAY", "JSON_EXISTS", "JSON_OBJECT", "JSON_QUERY", "JSON_TABLE", "JSON_VALUE", "LEFT", "LIKE", "LISTAGG", "LOCALTIME", "LOCALTIMESTAMP", "NATURAL", "NORMALIZE", "NOT", "NULL", "ON", "OR", "ORDER", "OUTER", "PREPARE", "RECURSIVE", "RIGHT", "ROLLUP", "SELECT", "SKIP", "TABLE", "THEN", "TRIM", "TRUE", "UESCAPE", "UNION", "UNNEST", "USING", "VALUES", "WHEN", "WHERE", "WITH", "FILL"};

    private String getInsertTableName(String tb) {
        Object insertTableName = tb;
        String[] stringArray = allIotdbTableSQLKeywords;
        int n = allIotdbTableSQLKeywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            if (tb.equalsIgnoreCase(keyword)) {
                insertTableName = "\"" + tb + "\"";
                break;
            }
            ++n2;
        }
        return insertTableName;
    }

    private String getTTL(DBRProgressMonitor monitor, GenericTableBase sourceObject, String databaseName) {
        String ttl = "";
        try {
            Throwable throwable = null;
            Object var6_10 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)sourceObject, (String)"Get IoTDB table details");){
                String sql = String.format("select * from information_schema.tables where database like '%s'", databaseName);
                JDBCStatement stmt = session.createStatement();
                JDBCResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    ttl = rs.getString("ttl(ms)");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            try {
                Throwable throwable = null;
                Object var6_12 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)sourceObject, (String)"Get IoTDB table details");){
                    String sql = String.format("show tables details from %s", databaseName);
                    JDBCStatement stmt = session.createStatement();
                    JDBCResultSet rs = stmt.executeQuery(sql);
                    while (rs.next()) {
                        ttl = rs.getString("TTL(ms)");
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Exception e1) {
                log.error((Object)"Error executing sql", (Throwable)e1);
            }
        }
        if (ttl.equals("INF")) {
            ttl = "'INF'";
        }
        return ttl;
    }

    private String getTableDDLInfoWithISPrivilege(JDBCSession session, GenericTableBase sourceObject, String databaseName, String insertTableName, String ttl) throws SQLException {
        StringBuilder toAppend = new StringBuilder(200);
        String sql = String.format("select * from information_schema.columns where database like '%s' and table_name like '%s'", databaseName, insertTableName);
        JDBCStatement stmt = session.createStatement();
        JDBCResultSet rs = stmt.executeQuery(sql);
        toAppend.append("CREATE TABLE ").append(insertTableName).append(" (\n");
        while (rs.next()) {
            toAppend.append("\t").append(rs.getString("column_name")).append(" ");
            toAppend.append(rs.getString("datatype")).append(" ");
            toAppend.append(rs.getString("category"));
            String columnComment = rs.getString("comment");
            if (columnComment != null && !columnComment.isEmpty()) {
                toAppend.append(" COMMENT '").append(columnComment).append("'");
            }
            toAppend.append(",\n");
        }
        toAppend.setLength(toAppend.length() - 2);
        String tableComment = sourceObject.getDescription();
        if (tableComment != null && !tableComment.isEmpty()) {
            toAppend.append("\n) COMMENT '").append(tableComment).append("' ");
            toAppend.append("WITH (TTL=").append(ttl).append(");");
        } else {
            toAppend.append("\n) WITH (TTL=").append(ttl).append(");");
        }
        return toAppend.toString();
    }

    private String getTableDDLInfoWithoutISPrivilege(JDBCSession session, GenericTableBase sourceObject, String databaseName, String insertTableName, String ttl) throws SQLException {
        StringBuilder toAppend = new StringBuilder(200);
        String sql = String.format("desc %s.%s details", databaseName, insertTableName);
        JDBCStatement stmt = session.createStatement();
        JDBCResultSet rs = stmt.executeQuery(sql);
        toAppend.append("CREATE TABLE ").append(insertTableName).append(" (\n");
        while (rs.next()) {
            toAppend.append("\t").append(rs.getString("ColumnName")).append(" ");
            toAppend.append(rs.getString("DataType")).append(" ");
            toAppend.append(rs.getString("Category"));
            String columnComment = rs.getString("Comment");
            if (columnComment != null && !columnComment.isEmpty()) {
                toAppend.append(" COMMENT '").append(columnComment).append("'");
            }
            toAppend.append(",\n");
        }
        toAppend.setLength(toAppend.length() - 2);
        String tableComment = sourceObject.getDescription();
        if (tableComment != null && !tableComment.isEmpty()) {
            toAppend.append("\n) COMMENT '").append(tableComment).append("' ");
            toAppend.append("WITH (TTL=").append(ttl).append(");");
        } else {
            toAppend.append("\n) WITH (TTL=").append(ttl).append(");");
        }
        return toAppend.toString();
    }

    public String getTableDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericTableBase sourceObject, @NotNull Map<String, Object> options) {
        String databaseName = sourceObject.getParentObject().getName();
        String tableName = sourceObject.getName();
        String insertTableName = this.getInsertTableName(tableName);
        StringBuilder ddl = new StringBuilder(200);
        ddl.append("DROP TABLE IF EXISTS ").append(insertTableName).append(";\n\n");
        String ttl = this.getTTL(monitor, sourceObject, databaseName);
        String toAppend = "";
        try {
            Throwable throwable = null;
            Object var11_15 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)sourceObject, (String)"Get IoTDB table column details");){
                toAppend = this.getTableDDLInfoWithISPrivilege(session, sourceObject, databaseName, insertTableName, ttl);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            try {
                Throwable throwable = null;
                Object var11_17 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)sourceObject, (String)"Get IoTDB table column details");){
                    toAppend = this.getTableDDLInfoWithoutISPrivilege(session, sourceObject, databaseName, insertTableName, ttl);
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Exception e1) {
                log.error((Object)"Error executing sql", (Throwable)e1);
            }
        }
        ddl.append(toAppend);
        return ddl.toString();
    }

    public boolean isTrimObjectNames() {
        return true;
    }
}

