/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.impl;

import java.util.List;
import java.util.StringJoiner;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObjectWithDescription;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.ai.AISchemaGenerationOptions;
import org.jkiss.dbeaver.model.ai.AISchemaGenerator;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;

public class AISchemaGeneratorImpl
implements AISchemaGenerator {
    @Override
    public String generateSchema(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity entity, @Nullable DBCExecutionContext ctx, @NotNull AISchemaGenerationOptions options, boolean useFqn) throws DBException {
        if (entity instanceof DBSTable) {
            DBSTable table = (DBSTable)entity;
            return this.describeTable(monitor, table, ctx, options, useFqn);
        }
        return "";
    }

    @NotNull
    public String describeTable(@NotNull DBRProgressMonitor monitor, @NotNull DBSTable table, @Nullable DBCExecutionContext ctx, @NotNull AISchemaGenerationOptions options, boolean useFqn) throws DBException {
        String tableDescription;
        String name;
        StringBuilder ddl = new StringBuilder();
        String string = name = useFqn && ctx != null ? DBUtils.getObjectFullName((DBPDataSource)ctx.getDataSource(), (DBPNamedObject)table, (DBPEvaluationContext)DBPEvaluationContext.DDL) : DBUtils.getQuotedIdentifier((DBSObject)table);
        if (options.sendObjectComment() && !(tableDescription = AISchemaGeneratorImpl.describe((DBPObjectWithDescription)table)).isBlank()) {
            ddl.append(tableDescription).append("\n");
        }
        if (table.isView()) {
            ddl.append("CREATE VIEW ");
        } else {
            ddl.append("CREATE TABLE ");
        }
        ddl.append(name);
        List attributes = table.getAttributes(monitor);
        if (attributes == null || attributes.isEmpty()) {
            return ddl.append(");").toString();
        }
        StringJoiner columnsJoiner = new StringJoiner(",", " (", ") ");
        attributes.forEach(attr -> {
            if (DBUtils.isHiddenObject((Object)attr)) {
                return;
            }
            columnsJoiner.add(DBUtils.getQuotedIdentifier((DBSObject)attr) + (String)(options.sendColumnTypes() ? " " + attr.getTypeName() : "") + (options.sendObjectComment() && !AISchemaGeneratorImpl.describe((DBPObjectWithDescription)attr).isBlank() ? AISchemaGeneratorImpl.describe((DBPObjectWithDescription)attr) : ""));
        });
        return ddl.append(columnsJoiner).toString();
    }

    @NotNull
    private static String describe(@NotNull DBPObjectWithDescription object) {
        String description = object.getDescription();
        if (description == null || description.isBlank()) {
            return "";
        }
        return "-- " + description + "\n";
    }
}

