/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

class SelectResourcesBlock
implements ICheckStateListener,
ISelectionChangedListener,
ITreeViewerListener {
    private Object root;
    private Object currentTreeSelection;
    private Collection<Object> expandedTreeNodes = new HashSet<Object>();
    private Map<Object, List<Object>> checkedStateStore = new HashMap<Object, List<Object>>(9);
    private Collection<Object> whiteCheckedTreeItems = new HashSet<Object>();
    private ListenerList<ICheckStateListener> listeners = new ListenerList(1);
    private ITreeContentProvider treeContentProvider;
    private IStructuredContentProvider listContentProvider;
    private ILabelProvider treeLabelProvider;
    private ILabelProvider listLabelProvider;
    private CheckboxTreeViewer treeViewer;
    private CheckboxTableViewer listViewer;
    private static int PREFERRED_HEIGHT = 150;

    public SelectResourcesBlock(Composite parent, Object rootObject, ITreeContentProvider treeContentProvider, ILabelProvider treeLabelProvider, IStructuredContentProvider listContentProvider, ILabelProvider listLabelProvider, int style, boolean useHeightHint) {
        this.root = rootObject;
        this.treeContentProvider = treeContentProvider;
        this.listContentProvider = listContentProvider;
        this.treeLabelProvider = treeLabelProvider;
        this.listLabelProvider = listLabelProvider;
        this.createContents(parent, style, useHeightHint);
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.listeners.add((Object)listener);
    }

    private void checkNewTreeElements(Object[] elements) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object currentElement = objectArray[n2];
            boolean checked = this.checkedStateStore.containsKey(currentElement);
            this.treeViewer.setChecked(currentElement, checked);
            this.treeViewer.setGrayed(currentElement, checked && !this.whiteCheckedTreeItems.contains(currentElement));
            ++n2;
        }
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), () -> {
            if (event.getCheckable().equals(this.treeViewer)) {
                this.treeItemChecked(event.getElement(), event.getChecked());
            } else {
                this.listItemChecked(event.getElement(), event.getChecked(), true);
            }
            this.notifyCheckStateChangeListeners(event);
        });
    }

    private void createContents(Composite parent, int style, boolean useHeightHint) {
        Composite composite = new Composite(parent, style);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createTreeViewer(composite, useHeightHint);
        this.createListViewer(composite, useHeightHint);
        this.initialize();
    }

    private void createListViewer(Composite parent, boolean useHeightHint) {
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        GridData data = new GridData(1808);
        if (useHeightHint) {
            data.heightHint = PREFERRED_HEIGHT;
        }
        data.widthHint = this.getViewerWidthHint((Control)parent);
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.getTable().setFont(parent.getFont());
        this.listViewer.setContentProvider((IContentProvider)this.listContentProvider);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.listLabelProvider);
        this.listViewer.addCheckStateListener((ICheckStateListener)this);
    }

    private void createTreeViewer(Composite parent, boolean useHeightHint) {
        Tree tree = new Tree(parent, 2080);
        GridData data = new GridData(1808);
        if (useHeightHint) {
            data.heightHint = PREFERRED_HEIGHT;
        }
        data.widthHint = this.getViewerWidthHint((Control)parent);
        tree.setLayoutData((Object)data);
        tree.setFont(parent.getFont());
        this.treeViewer = new CheckboxTreeViewer(tree);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setContentProvider((IContentProvider)this.treeContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.treeLabelProvider);
        this.treeViewer.addTreeListener((ITreeViewerListener)this);
        this.treeViewer.addCheckStateListener((ICheckStateListener)this);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private int getViewerWidthHint(Control control) {
        GC gc = new GC((Drawable)control);
        int width = Dialog.convertWidthInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)50);
        gc.dispose();
        return width;
    }

    private boolean determineShouldBeAtLeastGrayChecked(Object treeElement) {
        List<Object> checked = this.checkedStateStore.get(treeElement);
        if (checked != null && !checked.isEmpty()) {
            return true;
        }
        if (this.expandedTreeNodes.contains(treeElement)) {
            Object[] objectArray = this.treeContentProvider.getChildren(treeElement);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (this.checkedStateStore.containsKey(element)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void expandTreeElement(Object element) {
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), () -> {
            if (this.expandedTreeNodes.contains(element)) {
                this.checkNewTreeElements(this.treeContentProvider.getChildren(element));
            } else {
                this.expandedTreeNodes.add(element);
                if (this.whiteCheckedTreeItems.contains(element)) {
                    Object[] objectArray = this.treeContentProvider.getChildren(element);
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object child = objectArray[n2];
                        if (!this.whiteCheckedTreeItems.contains(child)) {
                            this.setWhiteChecked(child, true);
                            this.treeViewer.setChecked(child, true);
                            this.checkedStateStore.put(child, new ArrayList());
                        }
                        ++n2;
                    }
                    this.setListForWhiteSelection(element);
                }
            }
        });
    }

    private void findAllSelectedListElements(Object treeElement, String parentLabel, boolean addAll, IElementFilter filter) throws InterruptedException {
        Object[] treeChildren;
        String fullLabel = null;
        if (addAll) {
            filter.filterElements(this.listContentProvider.getElements(treeElement));
        } else if (this.checkedStateStore.containsKey(treeElement)) {
            filter.filterElements((Collection<Object>)this.checkedStateStore.get(treeElement));
        }
        Object[] objectArray = treeChildren = this.treeContentProvider.getChildren(treeElement);
        int n = treeChildren.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (addAll) {
                this.findAllSelectedListElements(child, fullLabel, true, filter);
            } else if (this.checkedStateStore.containsKey(child)) {
                this.findAllSelectedListElements(child, fullLabel, this.whiteCheckedTreeItems.contains(child), filter);
            }
            ++n2;
        }
    }

    private void findAllWhiteCheckedItems(Object treeElement, Collection<Object> result) {
        if (this.whiteCheckedTreeItems.contains(treeElement)) {
            result.add(treeElement);
        } else {
            Collection listChildren = this.checkedStateStore.get(treeElement);
            if (listChildren == null) {
                return;
            }
            result.addAll(listChildren);
            Object[] objectArray = this.treeContentProvider.getChildren(treeElement);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                this.findAllWhiteCheckedItems(element, result);
                ++n2;
            }
        }
    }

    private void getAllCheckedListItems(IElementFilter filter) throws InterruptedException {
        Object[] objectArray = this.treeContentProvider.getChildren(this.root);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.findAllSelectedListElements(element, null, this.whiteCheckedTreeItems.contains(element), filter);
            ++n2;
        }
    }

    public List<Object> getAllCheckedListItems() {
        final ArrayList<Object> returnValue = new ArrayList<Object>();
        IElementFilter passThroughFilter = new IElementFilter(){

            @Override
            public void filterElements(Collection<Object> elements) throws InterruptedException {
                returnValue.addAll(elements);
            }

            @Override
            public void filterElements(Object[] elements) throws InterruptedException {
                Collections.addAll(returnValue, elements);
            }
        };
        try {
            this.getAllCheckedListItems(passThroughFilter);
        }
        catch (InterruptedException exception) {
            return new ArrayList<Object>();
        }
        return returnValue;
    }

    public List<Object> getAllWhiteCheckedItems() {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] objectArray = this.treeContentProvider.getChildren(this.root);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.findAllWhiteCheckedItems(element, result);
            ++n2;
        }
        return result;
    }

    private void grayCheckHierarchy(Object treeElement) {
        this.expandTreeElement(treeElement);
        if (this.checkedStateStore.containsKey(treeElement)) {
            return;
        }
        this.checkedStateStore.put(treeElement, new ArrayList());
        Object parent = this.treeContentProvider.getParent(treeElement);
        if (parent != null) {
            this.grayCheckHierarchy(parent);
        }
    }

    private void grayUpdateHierarchy(Object treeElement) {
        Object parent;
        boolean shouldBeAtLeastGray = this.determineShouldBeAtLeastGrayChecked(treeElement);
        this.treeViewer.setGrayChecked(treeElement, shouldBeAtLeastGray);
        if (this.whiteCheckedTreeItems.contains(treeElement)) {
            this.whiteCheckedTreeItems.remove(treeElement);
        }
        if ((parent = this.treeContentProvider.getParent(treeElement)) != null) {
            this.grayUpdateHierarchy(parent);
        }
    }

    public void selectAndReveal(Object treeElement) {
        this.treeViewer.reveal(treeElement);
        StructuredSelection selection = new StructuredSelection(treeElement);
        this.treeViewer.setSelection((ISelection)selection);
    }

    private void initialize() {
        this.treeViewer.setInput(this.root);
        this.expandedTreeNodes = new ArrayList<Object>();
        this.expandedTreeNodes.add(this.root);
        Object[] topElements = this.treeContentProvider.getElements(this.root);
        if (topElements.length == 1) {
            this.treeViewer.setExpandedState(topElements[0], true);
        }
    }

    private void listItemChecked(Object listElement, boolean state, boolean updatingFromSelection) {
        List<Object> checkedListItems = this.checkedStateStore.get(this.currentTreeSelection);
        if (!this.expandedTreeNodes.contains(this.currentTreeSelection)) {
            this.expandTreeElement(this.currentTreeSelection);
        }
        if (state) {
            if (checkedListItems == null) {
                this.grayCheckHierarchy(this.currentTreeSelection);
                checkedListItems = this.checkedStateStore.get(this.currentTreeSelection);
            }
            checkedListItems.add(listElement);
        } else {
            checkedListItems.remove(listElement);
            if (checkedListItems.isEmpty()) {
                this.ungrayCheckHierarchy(this.currentTreeSelection);
            }
        }
        if (!checkedListItems.isEmpty()) {
            this.checkedStateStore.put(this.currentTreeSelection, checkedListItems);
        }
        if (updatingFromSelection) {
            this.grayUpdateHierarchy(this.currentTreeSelection);
        }
    }

    private void notifyCheckStateChangeListeners(final CheckStateChangedEvent event) {
        for (final ICheckStateListener l : this.listeners) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.checkStateChanged(event);
                }
            });
        }
    }

    private void populateListViewer(Object treeElement) {
        this.listViewer.setInput(treeElement);
        if (!this.expandedTreeNodes.contains(treeElement) && this.whiteCheckedTreeItems.contains(treeElement)) {
            BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), () -> {
                this.setListForWhiteSelection(treeElement);
                this.listViewer.setAllChecked(true);
            });
        } else {
            List<Object> listItemsToCheck = this.checkedStateStore.get(treeElement);
            if (listItemsToCheck != null) {
                Iterator<Object> listItemsEnum = listItemsToCheck.iterator();
                while (listItemsEnum.hasNext()) {
                    this.listViewer.setChecked(listItemsEnum.next(), true);
                }
            }
        }
    }

    private void primeHierarchyForSelection(Object item, Set<Object> selectedNodes) {
        if (selectedNodes.contains(item)) {
            return;
        }
        this.checkedStateStore.put(item, new ArrayList());
        this.expandedTreeNodes.add(item);
        selectedNodes.add(item);
        Object parent = this.treeContentProvider.getParent(item);
        if (parent != null) {
            this.primeHierarchyForSelection(parent, selectedNodes);
        }
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = event.getStructuredSelection();
        Object selectedElement = selection.getFirstElement();
        if (selectedElement == null) {
            this.currentTreeSelection = null;
            this.listViewer.setInput(null);
            return;
        }
        if (selectedElement != this.currentTreeSelection) {
            this.populateListViewer(selectedElement);
        }
        this.currentTreeSelection = selectedElement;
    }

    public void setAllSelections(boolean selection) {
        if (this.root == null) {
            return;
        }
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), () -> {
            this.setTreeChecked(this.root, selection);
            this.listViewer.setAllChecked(selection);
        });
    }

    public void refresh() {
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), () -> {
            this.treeViewer.refresh();
            this.populateListViewer(this.currentTreeSelection);
        });
    }

    private void setListForWhiteSelection(Object treeElement) {
        Object[] listItems = this.listContentProvider.getElements(treeElement);
        ArrayList listItemsChecked = new ArrayList();
        Collections.addAll(listItemsChecked, listItems);
        this.checkedStateStore.put(treeElement, listItemsChecked);
    }

    public void setListComparator(ViewerComparator comparator) {
        this.listViewer.setComparator(comparator);
    }

    private void setTreeChecked(Object treeElement, boolean state) {
        if (treeElement.equals(this.currentTreeSelection)) {
            this.listViewer.setAllChecked(state);
        }
        if (state) {
            this.setListForWhiteSelection(treeElement);
        } else {
            this.checkedStateStore.remove(treeElement);
        }
        this.setWhiteChecked(treeElement, state);
        this.treeViewer.setChecked(treeElement, state);
        this.treeViewer.setGrayed(treeElement, false);
        if (this.expandedTreeNodes.contains(treeElement)) {
            Object[] objectArray = this.treeContentProvider.getChildren(treeElement);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                this.setTreeChecked(element, state);
                ++n2;
            }
        }
    }

    public void setTreeComparator(ViewerComparator comparator) {
        this.treeViewer.setComparator(comparator);
    }

    private void setWhiteChecked(Object treeElement, boolean isWhiteChecked) {
        if (isWhiteChecked) {
            if (!this.whiteCheckedTreeItems.contains(treeElement)) {
                this.whiteCheckedTreeItems.add(treeElement);
            }
        } else {
            this.whiteCheckedTreeItems.remove(treeElement);
        }
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    public void treeExpanded(TreeExpansionEvent event) {
        this.expandTreeElement(event.getElement());
    }

    private void treeItemChecked(Object treeElement, boolean state) {
        this.setTreeChecked(treeElement, state);
        Object parent = this.treeContentProvider.getParent(treeElement);
        if (parent == null) {
            return;
        }
        if (state) {
            this.grayCheckHierarchy(parent);
        } else {
            this.ungrayCheckHierarchy(parent);
        }
        this.grayUpdateHierarchy(parent);
    }

    private void ungrayCheckHierarchy(Object treeElement) {
        Object parent;
        if (!this.determineShouldBeAtLeastGrayChecked(treeElement)) {
            this.checkedStateStore.remove(treeElement);
        }
        if ((parent = this.treeContentProvider.getParent(treeElement)) != null) {
            this.ungrayCheckHierarchy(parent);
        }
    }

    public void updateSelections(Map<IContainer, List<Object>> items) {
        List<Object> displayItems;
        this.listViewer.setAllChecked(false);
        this.treeViewer.setCheckedElements(new Object[0]);
        this.whiteCheckedTreeItems = new HashSet<Object>();
        HashSet<Object> selectedNodes = new HashSet<Object>();
        this.checkedStateStore = new HashMap<Object, List<Object>>();
        for (Map.Entry<IContainer, List<Object>> entry : items.entrySet()) {
            IContainer key = entry.getKey();
            this.primeHierarchyForSelection(key, selectedNodes);
            this.checkedStateStore.put(key, entry.getValue());
        }
        this.treeViewer.setCheckedElements(this.checkedStateStore.keySet().toArray());
        this.treeViewer.setGrayedElements(this.checkedStateStore.keySet().toArray());
        if (this.currentTreeSelection != null && (displayItems = items.get(this.currentTreeSelection)) != null) {
            this.listViewer.setCheckedElements(displayItems.toArray());
        }
    }

    static interface IElementFilter {
        public void filterElements(Collection<Object> var1) throws InterruptedException;

        public void filterElements(Object[] var1) throws InterruptedException;
    }
}

