/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeGrant;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRoleReference;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class PostgreObjectPrivilege
extends PostgrePrivilege {
    private static final Log log = Log.getLog(PostgreObjectPrivilege.class);
    private final PostgreRoleReference grantee;

    public PostgreObjectPrivilege(PostgrePrivilegeOwner owner, PostgreRoleReference grantee, List<PostgrePrivilegeGrant> privileges) {
        super(owner, privileges);
        this.grantee = grantee;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.grantee == null ? "" : this.grantee.getDisplayString();
    }

    @Override
    public PostgreRole getTargetObject(DBRProgressMonitor monitor) throws DBException {
        return this.owner.getDatabase().getRoleByReference(monitor, this.grantee);
    }

    public PostgreRoleReference getGrantee() {
        return this.grantee;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(@NotNull PostgrePrivilege o) {
        if (o instanceof PostgreObjectPrivilege) {
            PostgreObjectPrivilege other = (PostgreObjectPrivilege)o;
            return this.grantee.compareTo(other.grantee);
        }
        return 0;
    }
}

