/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.tools;

import java.math.BigInteger;
import java.util.Collection;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.OptToPBSATAdapter;
import org.sat4j.pb.multiobjective.IMultiObjOptimizationProblem;
import org.sat4j.pb.tools.DependencyHelper;
import org.sat4j.pb.tools.WeightedObject;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolutionFoundListener;

public class LinMultiObjHelper<T, C>
extends DependencyHelper<T, C>
implements SolutionFoundListener {
    private IMultiObjOptimizationProblem solver;
    private boolean hasASolution;
    private boolean isOptimal = false;

    public LinMultiObjHelper(IMultiObjOptimizationProblem solver) {
        this(solver, false);
    }

    public LinMultiObjHelper(IMultiObjOptimizationProblem solver, boolean explanationEnabled) {
        this(solver, false, false);
    }

    public LinMultiObjHelper(IMultiObjOptimizationProblem solver, boolean explanationEnabled, boolean canonicalOptFunctionEnabled) {
        super(new OptToPBSATAdapter(solver), explanationEnabled, canonicalOptFunctionEnabled);
        this.solver = solver;
        ((OptToPBSATAdapter)this.getSolver()).setSolutionFoundListener(this);
    }

    public void addCriterion(Collection<T> things) {
        VecInt literals = new VecInt(things.size());
        for (T thing : things) {
            literals.push(this.getIntValue(thing));
        }
        this.solver.addObjectiveFunction(new ObjectiveFunction((IVecInt)literals, (IVec<BigInteger>)new Vec(literals.size(), (Object)BigInteger.ONE)));
    }

    public void addWeightedCriterion(Collection<WeightedObject<T>> things) {
        VecInt literals = new VecInt(things.size());
        Vec coefs = new Vec(things.size());
        for (WeightedObject<T> wo : things) {
            literals.push(this.getIntValue(wo.thing));
            coefs.push((Object)wo.getWeight());
        }
        this.solver.addObjectiveFunction(new ObjectiveFunction((IVecInt)literals, (IVec<BigInteger>)coefs));
    }

    @Override
    public boolean hasASolution() throws TimeoutException {
        try {
            return super.hasASolution();
        }
        catch (TimeoutException e) {
            if (this.hasASolution) {
                return true;
            }
            throw e;
        }
    }

    @Override
    public boolean hasASolution(IVec<T> assumps) throws TimeoutException {
        try {
            return super.hasASolution(assumps);
        }
        catch (TimeoutException e) {
            if (this.hasASolution) {
                return true;
            }
            throw e;
        }
    }

    @Override
    public boolean hasASolution(Collection<T> assumps) throws TimeoutException {
        try {
            return super.hasASolution(assumps);
        }
        catch (TimeoutException e) {
            if (this.hasASolution) {
                return true;
            }
            throw e;
        }
    }

    public boolean isOptimal() {
        return this.isOptimal || this.solver.isOptimal();
    }

    public void onSolutionFound(int[] solution) {
        this.hasASolution = true;
    }

    public void onSolutionFound(IVecInt solution) {
        this.hasASolution = true;
    }

    public void onUnsatTermination() {
        if (this.hasASolution) {
            this.isOptimal = true;
        }
    }
}

