/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.jface.viewers.IColorDecorator;
import org.eclipse.jface.viewers.IFontDecorator;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

class MultiLabelDecorator
extends LabelProvider
implements ILabelDecorator,
IFontDecorator,
IColorDecorator {
    private final ILabelDecorator[] decorators;

    public MultiLabelDecorator(ILabelDecorator[] decorators) {
        this.decorators = decorators;
    }

    public Image decorateImage(Image image, Object element) {
        ILabelDecorator[] iLabelDecoratorArray = this.decorators;
        int n = this.decorators.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelDecorator decorator = iLabelDecoratorArray[n2];
            Image newImage = decorator.decorateImage(image, element);
            if (newImage != null) {
                image = newImage;
            }
            ++n2;
        }
        return image;
    }

    public String decorateText(String text, Object element) {
        ILabelDecorator[] iLabelDecoratorArray = this.decorators;
        int n = this.decorators.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelDecorator decorator = iLabelDecoratorArray[n2];
            String newText = decorator.decorateText(text, element);
            if (newText != null) {
                text = newText;
            }
            ++n2;
        }
        return text;
    }

    public void dispose() {
        ILabelDecorator[] iLabelDecoratorArray = this.decorators;
        int n = this.decorators.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelDecorator d = iLabelDecoratorArray[n2];
            d.dispose();
            ++n2;
        }
    }

    public Font decorateFont(Object element) {
        ILabelDecorator[] iLabelDecoratorArray = this.decorators;
        int n = this.decorators.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelDecorator decorator = iLabelDecoratorArray[n2];
            if (decorator instanceof IFontDecorator) {
                return ((IFontDecorator)decorator).decorateFont(element);
            }
            ++n2;
        }
        return null;
    }

    public Color decorateForeground(Object element) {
        ILabelDecorator[] iLabelDecoratorArray = this.decorators;
        int n = this.decorators.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelDecorator decorator = iLabelDecoratorArray[n2];
            if (decorator instanceof IColorDecorator) {
                return ((IColorDecorator)decorator).decorateForeground(element);
            }
            ++n2;
        }
        return null;
    }

    public Color decorateBackground(Object element) {
        ILabelDecorator[] iLabelDecoratorArray = this.decorators;
        int n = this.decorators.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelDecorator decorator = iLabelDecoratorArray[n2];
            if (decorator instanceof IColorDecorator) {
                return ((IColorDecorator)decorator).decorateBackground(element);
            }
            ++n2;
        }
        return null;
    }
}

