/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.StringJoiner;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.progress.UIJob;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelection;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelectionExt;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetListenerAdapter;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;

class ResultSetStatListener
extends ResultSetListenerAdapter {
    private final ResultSetViewer viewer;
    private SLUpdateJob updateJob;

    ResultSetStatListener(ResultSetViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public void handleResultSetSelectionChange(SelectionChangedEvent event) {
        this.viewer.getSelection();
        IWorkbenchPartSite site = this.viewer.getSite();
        if (site instanceof IEditorSite) {
            if (this.updateJob == null) {
                this.updateJob = new SLUpdateJob();
            }
            this.updateJob.schedule(100L);
        }
    }

    class SLUpdateJob
    extends UIJob {
        SLUpdateJob() {
            super("Update status line");
            this.setSystem(true);
            this.setUser(false);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            IResultSetSelection selection = ResultSetStatListener.this.viewer.getSelection();
            DBPPreferenceStore preferenceStore = ResultSetStatListener.this.viewer.getPreferenceStore();
            this.updateSelectionStatistics(selection, preferenceStore);
            return Status.OK_STATUS;
        }

        private void updateSelectionStatistics(IResultSetSelection selection, DBPPreferenceStore preferenceStore) {
            if (selection.getSelectedAttributes().isEmpty()) {
                this.updateSelectionStatistics(preferenceStore, null);
            } else if (selection instanceof IResultSetSelectionExt) {
                IResultSetSelectionExt selectionExt = (IResultSetSelectionExt)selection;
                this.updateSelectionStatistics(preferenceStore, selectionExt);
            }
        }

        private void updateSelectionStatistics(@NotNull DBPPreferenceStore preferenceStore, @Nullable IResultSetSelectionExt selectionExt) {
            StringJoiner slText = new StringJoiner(", ");
            if (preferenceStore.getBoolean("resultset.show.selected.rows")) {
                slText.add(NLS.bind((String)ResultSetMessages.result_set_stat_rows, (Object)(selectionExt == null ? 0 : selectionExt.getSelectedRowCount())));
            }
            if (preferenceStore.getBoolean("resultset.show.selected.columns")) {
                slText.add(NLS.bind((String)ResultSetMessages.result_set_stat_columns, (Object)(selectionExt == null ? 0 : selectionExt.getSelectedColumnCount())));
            }
            if (preferenceStore.getBoolean("resultset.show.selected.cells")) {
                slText.add(NLS.bind((String)ResultSetMessages.result_set_stat_cells, (Object)(selectionExt == null ? 0 : selectionExt.getSelectedCellCount())));
            }
            ResultSetStatListener.this.viewer.setSelectionStatistics(slText.toString());
        }
    }
}

