/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.actions;

import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.actions.AbstractResultSetViewerAction;

public class OrderByAttributeAction
extends AbstractResultSetViewerAction {
    private final DBDAttributeBinding attribute;
    private final IResultSetController.ColumnOrder order;

    public OrderByAttributeAction(ResultSetViewer resultSetViewer, DBDAttributeBinding attribute, IResultSetController.ColumnOrder order) {
        super(resultSetViewer, order == IResultSetController.ColumnOrder.NONE ? "Disable order by " + attribute.getName() : "Order by " + attribute.getName() + " " + order.name(), 2);
        this.attribute = attribute;
        this.order = order;
        if (order != IResultSetController.ColumnOrder.NONE) {
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)(order != IResultSetController.ColumnOrder.ASC ? UIIcon.SORT_INCREASE : UIIcon.SORT_DECREASE)));
        }
    }

    public boolean isChecked() {
        if (this.order == IResultSetController.ColumnOrder.NONE) {
            return false;
        }
        DBDDataFilter dataFilter = this.getResultSetViewer().getModel().getDataFilter();
        DBDAttributeConstraint constraint = dataFilter.getConstraint(this.attribute);
        if (constraint == null || constraint.getOrderPosition() <= 0) {
            return false;
        }
        boolean forceAsc = this.order == IResultSetController.ColumnOrder.ASC;
        return constraint.isOrderDescending() ^ forceAsc;
    }

    public void run() {
        this.getResultSetViewer().toggleSortOrder(this.attribute, this.order);
    }
}

