/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data.handlers;

import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.data.DBDValueHandlerProvider;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCArrayValueHandler;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCBooleanValueHandler;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCContentValueHandler;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCDateTimeValueHandler;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCNumberValueHandler;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCObjectValueHandler;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCReferenceValueHandler;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCStringValueHandler;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCStructValueHandler;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCUUIDValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class JDBCStandardValueHandlerProvider
implements DBDValueHandlerProvider {
    private static final boolean LONGVARCHAR_AS_LOB = false;

    public DBDValueHandler getValueHandler(DBPDataSource dataSource, DBDFormatSettings preferences, DBSTypedObject typedObject) {
        int valueType = typedObject.getTypeID();
        DBPDataKind dataKind = typedObject.getDataKind();
        switch (dataKind) {
            case BOOLEAN: {
                return new JDBCBooleanValueHandler();
            }
            case STRING: {
                return JDBCStringValueHandler.INSTANCE;
            }
            case NUMERIC: {
                return new JDBCNumberValueHandler(typedObject, preferences);
            }
            case DATETIME: {
                return new JDBCDateTimeValueHandler(preferences);
            }
            case BINARY: 
            case CONTENT: {
                if ("UUID".equalsIgnoreCase(typedObject.getTypeName())) {
                    return JDBCUUIDValueHandler.INSTANCE;
                }
                return JDBCContentValueHandler.INSTANCE;
            }
            case ARRAY: {
                return JDBCArrayValueHandler.INSTANCE;
            }
            case STRUCT: {
                return JDBCStructValueHandler.INSTANCE;
            }
            case REFERENCE: {
                return JDBCReferenceValueHandler.INSTANCE;
            }
            case ROWID: {
                return JDBCObjectValueHandler.INSTANCE;
            }
        }
        return null;
    }
}

