/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.function.BiConsumer;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.event.ProxyOutputter;
import net.sf.saxon.event.ReceiverOption;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.UniStringConsumer;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.z.IntIterator;

public final class ValueOf
extends SimpleNodeConstructor {
    private int options;
    private boolean numberingInstruction = false;
    private final boolean noNodeIfEmpty;

    public ValueOf(Expression select, boolean disable, boolean noNodeIfEmpty) {
        this.setSelect(select);
        this.options = disable ? 1 : 0;
        this.noNodeIfEmpty = noNodeIfEmpty;
        this.adoptChildExpression(select);
        if (select instanceof StringLiteral) {
            boolean special = false;
            UnicodeString val = ((StringLiteral)select).getString();
            IntIterator iter = val.codePoints();
            while (iter.hasNext()) {
                int c = iter.next();
                if (c >= 33 && c <= 126 && c != 60 && c != 62 && c != 38) continue;
                special = true;
                break;
            }
            if (!special) {
                this.options |= 4;
            }
        }
    }

    public void setIsNumberingInstruction() {
        this.numberingInstruction = true;
    }

    public boolean isNumberingInstruction() {
        return this.numberingInstruction;
    }

    public boolean isNoNodeIfEmpty() {
        return this.noNodeIfEmpty;
    }

    @Override
    public String toShortString() {
        if (this.getSelect() instanceof StringLiteral) {
            return "text{" + Err.depict(((StringLiteral)this.getSelect()).getGroundedValue()) + "}";
        }
        return super.toShortString();
    }

    @Override
    public void gatherProperties(BiConsumer<String, Object> consumer) {
        if (this.getSelect() instanceof StringLiteral) {
            consumer.accept("text", ((StringLiteral)this.getSelect()).getGroundedValue().getUnicodeStringValue());
        }
    }

    @Override
    public int getInstructionNameCode() {
        if (this.numberingInstruction) {
            return 186;
        }
        if (this.getSelect() instanceof StringLiteral) {
            return 211;
        }
        return 215;
    }

    public int getOptions() {
        return this.options;
    }

    public boolean isDisableOutputEscaping() {
        return ReceiverOption.contains(this.options, 1);
    }

    @Override
    public ItemType getItemType() {
        return NodeKindTest.TEXT;
    }

    @Override
    protected int computeCardinality() {
        if (this.noNodeIfEmpty) {
            return 24576;
        }
        return 16384;
    }

    @Override
    public void localTypeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) {
    }

    @Override
    public int getIntrinsicDependencies() {
        int d = super.getIntrinsicDependencies();
        if (this.isDisableOutputEscaping()) {
            d |= 0x200;
        }
        return d;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        ValueOf exp = new ValueOf(this.getSelect().copy(rebindings), ReceiverOption.contains(this.options, 1), this.noNodeIfEmpty);
        ExpressionTool.copyLocationInfo(this, exp);
        if (this.numberingInstruction) {
            exp.setIsNumberingInstruction();
        }
        return exp;
    }

    @Override
    public void checkPermittedContents(SchemaType parentType, boolean whole) throws XPathException {
        if (this.getSelect() instanceof Literal) {
            GroundedValue selectValue = ((Literal)this.getSelect()).getGroundedValue();
            SimpleType stype = null;
            if (parentType instanceof SimpleType && whole) {
                stype = (SimpleType)parentType;
            } else if (parentType instanceof ComplexType && ((ComplexType)parentType).isSimpleContent()) {
                stype = ((ComplexType)parentType).getSimpleContentType();
            }
            if (whole && stype != null && !stype.isNamespaceSensitive()) {
                ValidationFailure err = stype.validateContent(selectValue.getUnicodeStringValue(), null, this.getConfiguration().getConversionRules());
                if (err != null) {
                    err.setLocator(this.getLocation());
                    err.setErrorCode(this.isXSLT() ? "XTTE1540" : "XQDY0027");
                    throw err.makeException();
                }
                return;
            }
            if (parentType instanceof ComplexType && !((ComplexType)parentType).isSimpleContent() && !((ComplexType)parentType).isMixedContent() && !Whitespace.isAllWhite(selectValue.getUnicodeStringValue())) {
                XPathException err = new XPathException("The containing element must be of type " + parentType.getDescription() + ", which does not allow text content " + Err.wrap(selectValue.getUnicodeStringValue()));
                err.setLocation(this.getLocation());
                err.setIsTypeError(true);
                throw err;
            }
        }
    }

    public Expression convertToCastAsString() {
        if (this.noNodeIfEmpty || !Cardinality.allowsZero(this.getSelect().getCardinality())) {
            return new CastExpression(this.getSelect(), BuiltInAtomicType.UNTYPED_ATOMIC, true);
        }
        Expression sf = SystemFunction.makeCall("string", this.getRetainedStaticContext(), this.getSelect());
        return new CastExpression(sf, BuiltInAtomicType.UNTYPED_ATOMIC, false);
    }

    @Override
    public TailCall processLeavingTail(Outputter output, XPathContext context) throws XPathException {
        if (this.noNodeIfEmpty) {
            Item value = this.getSelect().evaluateItem(context);
            if (value != null) {
                this.processValue(value.getUnicodeStringValue(), output, context);
            }
            return null;
        }
        if (this.getSelect().getItemType() == BuiltInAtomicType.STRING && !this.isDisableOutputEscaping() && !Cardinality.allowsZero(this.getCardinality())) {
            final Location instructionLoc = this.getLocation();
            ProxyOutputter toText = new ProxyOutputter(output){

                @Override
                public void append(Item item) throws XPathException {
                    this.getNextOutputter().characters(item.getUnicodeStringValue(), instructionLoc, ValueOf.this.options);
                }

                @Override
                public void append(Item item, Location loc, int properties) throws XPathException {
                    Location location = loc.getLineNumber() == -1 ? instructionLoc : loc;
                    this.getNextOutputter().characters(item.getUnicodeStringValue(), location, properties | ValueOf.this.options);
                }

                @Override
                public UniStringConsumer getStringReceiver(boolean asTextNode, Location loc) {
                    Location location = loc.getLineNumber() == -1 ? instructionLoc : loc;
                    return this.getNextOutputter().getStringReceiver(true, location);
                }
            };
            this.getSelect().process(toText, context);
            return null;
        }
        return super.processLeavingTail(output, context);
    }

    @Override
    public void processValue(UnicodeString value, Outputter output, XPathContext context) throws XPathException {
        output.characters(value, this.getLocation(), this.options);
    }

    @Override
    public NodeInfo evaluateItem(XPathContext context) throws XPathException {
        try {
            UnicodeString val;
            Item item = this.getSelect().evaluateItem(context);
            if (item == null) {
                if (this.noNodeIfEmpty) {
                    return null;
                }
                val = EmptyUnicodeString.getInstance();
            } else {
                val = item.getUnicodeStringValue();
            }
            Controller controller = context.getController();
            assert (controller != null);
            Orphan o = new Orphan(controller.getConfiguration());
            o.setNodeKind((short)3);
            o.setStringValue(val);
            if (this.isDisableOutputEscaping()) {
                o.setDisableOutputEscaping(true);
            }
            return o;
        }
        catch (XPathException err) {
            err.maybeSetLocation(this.getLocation());
            throw err;
        }
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("valueOf", this);
        String flags = "";
        if (this.isDisableOutputEscaping()) {
            flags = flags + "d";
        }
        if (ReceiverOption.contains(this.options, 4)) {
            flags = flags + "S";
        }
        if (this.noNodeIfEmpty) {
            flags = flags + "e";
        }
        if (this.isLocal()) {
            flags = flags + "l";
        }
        if (!flags.isEmpty()) {
            out.emitAttribute("flags", flags);
        }
        this.getSelect().export(out);
        out.endElement();
    }
}

