/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.epubcheck.core.references;

import com.adobe.epubcheck.api.LocalizableReport;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.LocalizedMessages;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.ocf.OCFContainer;
import com.adobe.epubcheck.opf.OPFChecker;
import com.adobe.epubcheck.opf.OPFChecker30;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FeatureEnum;
import com.google.common.base.Preconditions;
import io.mola.galimatias.URL;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import org.w3c.epubcheck.constants.MIMEType;
import org.w3c.epubcheck.core.CheckAbortException;
import org.w3c.epubcheck.core.references.Reference;
import org.w3c.epubcheck.core.references.ReferenceRegistry;
import org.w3c.epubcheck.core.references.Resource;
import org.w3c.epubcheck.core.references.ResourceRegistry;
import org.w3c.epubcheck.util.url.URLFragment;

public class ResourceReferencesChecker {
    private final Report report;
    private final OCFContainer container;
    private final EPUBVersion version;
    private final ReferenceRegistry referenceRegistry;
    private final ResourceRegistry resourceRegistry;
    private Locale locale;
    private Set<URL> undeclared;

    public ResourceReferencesChecker(ValidationContext context) {
        Preconditions.checkArgument((boolean)context.container.isPresent());
        Preconditions.checkArgument((boolean)context.resourceRegistry.isPresent());
        Preconditions.checkArgument((boolean)context.referenceRegistry.isPresent());
        this.report = context.report;
        this.container = (OCFContainer)context.container.get();
        this.version = context.version;
        this.referenceRegistry = (ReferenceRegistry)context.referenceRegistry.get();
        this.resourceRegistry = (ResourceRegistry)context.resourceRegistry.get();
        this.locale = this.report instanceof LocalizableReport ? ((LocalizableReport)this.report).getLocale() : Locale.ENGLISH;
    }

    public void check() {
        this.undeclared = new HashSet<URL>();
        LinkedList<Reference> tocLinks = new LinkedList<Reference>();
        LinkedList<Reference> pageListLinks = new LinkedList<Reference>();
        LinkedList<Reference> overlayLinks = new LinkedList<Reference>();
        block6: for (Reference reference : this.referenceRegistry.asList()) {
            switch (reference.type) {
                case REGION_BASED_NAV: {
                    this.checkRegionBasedNav(reference);
                    continue block6;
                }
                case NAV_TOC_LINK: {
                    tocLinks.add(reference);
                    continue block6;
                }
                case NAV_PAGELIST_LINK: {
                    pageListLinks.add(reference);
                    continue block6;
                }
                case OVERLAY_TEXT_LINK: {
                    overlayLinks.add(reference);
                    this.checkReference(reference);
                    continue block6;
                }
            }
            this.checkReference(reference);
        }
        this.checkReadingOrder(tocLinks);
        this.checkReadingOrder(overlayLinks);
    }

    private void checkReference(Reference reference) {
        this.report.info(reference.location.getPath(), FeatureEnum.RESOURCE, this.container.relativize(reference.url));
        Optional<Resource> targetResource = this.resourceRegistry.getResource(reference.targetResource);
        try {
            if (this.container.isRemote(reference.url)) {
                this.checkRemoteReference(reference, targetResource);
            }
            if (!targetResource.isPresent()) {
                this.checkUndeclaredReference(reference);
            }
            assert (targetResource.isPresent());
            this.checkFallbacks(reference, targetResource.get());
            URLFragment fragment = URLFragment.parse(reference.url, targetResource.get().getMimeType());
            this.checkReferenceType(reference, targetResource.get(), fragment);
            this.checkFragment(reference, targetResource.get(), fragment);
        }
        catch (CheckAbortException checkAbortException) {
            // empty catch block
        }
    }

    private void checkFragment(Reference reference, Resource targetResource, URLFragment fragment) throws CheckAbortException {
        String targetMimetype = targetResource.getMimeType();
        if (fragment.exists() && !fragment.isEmpty()) {
            if (reference.type == Reference.Type.OVERLAY_TEXT_LINK) {
                if (MIMEType.XHTML.is(targetMimetype) && fragment.getId().isEmpty()) {
                    this.report.message(MessageId.MED_017, reference.location, fragment.toString());
                } else if (MIMEType.SVG.is(targetMimetype) && !fragment.isValid()) {
                    this.report.message(MessageId.MED_018, reference.location, fragment.toString());
                }
            }
            if (!fragment.getId().isEmpty() && !this.container.isRemote(reference.targetResource)) {
                Reference.Type targetIDType = this.resourceRegistry.getIDType(fragment.getId(), targetResource);
                if (targetIDType == null && (MIMEType.SVG.is(targetMimetype) || MIMEType.XHTML.is(targetMimetype))) {
                    this.report.message(MessageId.RSC_012, reference.location.context(reference.url.toString()), new Object[0]);
                    throw new CheckAbortException();
                }
                switch (reference.type) {
                    case SVG_PAINT: 
                    case SVG_CLIP_PATH: {
                        if (targetIDType == reference.type) break;
                        this.report.message(MessageId.RSC_014, reference.location.context(reference.url.toString()), new Object[0]);
                        throw new CheckAbortException();
                    }
                    case OVERLAY_TEXT_LINK: 
                    case SVG_SYMBOL: 
                    case CITE: 
                    case HYPERLINK: {
                        if (targetIDType == reference.type || targetIDType == Reference.Type.GENERIC) break;
                        this.report.message(MessageId.RSC_014, reference.location.context(reference.url.toString()), new Object[0]);
                        throw new CheckAbortException();
                    }
                }
            }
        }
    }

    private void checkReferenceType(Reference reference, Resource targetResource, URLFragment fragment) throws CheckAbortException {
        String targetMimetype = targetResource.getMimeType();
        switch (reference.type) {
            case HYPERLINK: {
                if ("epubcfi".equals(fragment.getScheme())) break;
                if (!(OPFChecker.isBlessedItemType(targetMimetype, this.version) || OPFChecker.isDeprecatedBlessedItemType(targetMimetype) || targetResource.hasContentDocumentFallback())) {
                    this.report.message(MessageId.RSC_010, reference.location.context(this.container.relativize(reference.url)), new Object[0]);
                    throw new CheckAbortException();
                }
                if (targetResource.isInSpine()) break;
                this.report.message(MessageId.RSC_011, reference.location.context(this.container.relativize(reference.url)), new Object[0]);
                throw new CheckAbortException();
            }
            case IMAGE: {
                if ("epubcfi".equals(fragment.getScheme()) || !fragment.exists() || MIMEType.SVG.is(targetMimetype)) break;
                this.report.message(MessageId.RSC_009, reference.location.context(this.container.relativize(reference.url)), new Object[0]);
                throw new CheckAbortException();
            }
            case OVERLAY_TEXT_LINK: {
                if (OPFChecker.isBlessedItemType(targetMimetype, this.version)) break;
                this.report.message(MessageId.RSC_010, reference.location.context(this.container.relativize(reference.url)), new Object[0]);
                throw new CheckAbortException();
            }
            case SEARCH_KEY: {
                if (fragment.exists() && "epubcfi".equals(fragment.getScheme()) || targetResource.isInSpine()) break;
                this.report.message(MessageId.RSC_021, reference.location, this.container.relativize(reference.targetResource));
                throw new CheckAbortException();
            }
            case STYLESHEET: {
                if (!fragment.exists()) break;
                this.report.message(MessageId.RSC_013, reference.location.context(this.container.relativize(reference.url)), new Object[0]);
                throw new CheckAbortException();
            }
            case SVG_PAINT: 
            case SVG_CLIP_PATH: 
            case SVG_SYMBOL: {
                if (fragment.exists()) break;
                this.report.message(MessageId.RSC_015, reference.location.context(reference.url), new Object[0]);
                throw new CheckAbortException();
            }
        }
    }

    private void checkFallbacks(Reference reference, Resource targetResource) {
        String targetMimetype = targetResource.getMimeType();
        switch (reference.type) {
            case IMAGE: 
            case AUDIO: 
            case VIDEO: 
            case GENERIC: {
                if (reference.hasIntrinsicFallback || OPFChecker30.isCoreMediaType(targetMimetype) || targetResource.hasCoreMediaTypeFallback()) break;
                this.report.message(MessageId.RSC_032, reference.location, this.container.relativize(reference.targetResource), targetMimetype);
                break;
            }
        }
    }

    private void checkUndeclaredReference(Reference reference) throws CheckAbortException {
        assert (!this.resourceRegistry.getResource(reference.targetResource).isPresent());
        if (!this.container.contains(reference.url) && !this.container.isRemote(reference.url)) {
            if (this.version == EPUBVersion.VERSION_3 && reference.type == Reference.Type.LINK) {
                this.report.message(MessageId.RSC_007w, reference.location, this.container.relativize(reference.targetResource));
            } else {
                this.report.message(MessageId.RSC_007, reference.location, this.container.relativize(reference.targetResource));
            }
        } else if (!this.undeclared.contains(reference.targetResource) && reference.type != Reference.Type.LINK && (!this.container.isRemote(reference.targetResource) || reference.type != Reference.Type.HYPERLINK && reference.type != Reference.Type.CITE)) {
            this.undeclared.add(reference.targetResource);
            this.report.message(MessageId.RSC_008, reference.location, this.container.relativize(reference.targetResource));
        }
        throw new CheckAbortException();
    }

    private void checkRemoteReference(Reference reference, Optional<Resource> targetResource) throws CheckAbortException {
        assert (this.container.isRemote(reference.url));
        if (!(EnumSet.of(Reference.Type.CITE, Reference.Type.LINK, Reference.Type.HYPERLINK).contains((Object)reference.type) || this.version == EPUBVersion.VERSION_3 && targetResource.isPresent() && targetResource.get().isInSpine() || this.version == EPUBVersion.VERSION_3 && (targetResource.isPresent() && (OPFChecker30.isAudioType(targetResource.get().getMimeType()) || OPFChecker30.isVideoType(targetResource.get().getMimeType()) || OPFChecker30.isFontType(targetResource.get().getMimeType())) || reference.type == Reference.Type.FONT || reference.type == Reference.Type.AUDIO || reference.type == Reference.Type.VIDEO))) {
            this.report.message(MessageId.RSC_006, reference.location, reference.url);
            throw new CheckAbortException();
        }
        if (!(this.version != EPUBVersion.VERSION_3 || EnumSet.of(Reference.Type.LINK, Reference.Type.HYPERLINK).contains((Object)reference.type) || "https".equals(reference.url.scheme()) || "file".equals(reference.url.scheme()))) {
            this.report.message(MessageId.RSC_031, reference.location, reference.url);
        }
    }

    private void checkRegionBasedNav(Reference ref) {
        Preconditions.checkArgument((ref.type == Reference.Type.REGION_BASED_NAV ? 1 : 0) != 0);
        Optional<Resource> optionalResource = this.resourceRegistry.getResource(ref.targetResource);
        if (!(optionalResource.isPresent() && optionalResource.get().hasItem() && optionalResource.get().getItem().isFixedLayout())) {
            this.report.message(MessageId.NAV_009, ref.location, new Object[0]);
        }
    }

    private void checkReadingOrder(Queue<Reference> references) {
        int lastSpinePosition = -1;
        int lastAnchorPosition = -1;
        while (!references.isEmpty()) {
            URLFragment fragment;
            int targetAnchorPosition;
            Reference ref = references.poll();
            Preconditions.checkArgument((ref.type == Reference.Type.NAV_PAGELIST_LINK || ref.type == Reference.Type.NAV_TOC_LINK || ref.type == Reference.Type.OVERLAY_TEXT_LINK ? 1 : 0) != 0);
            Optional<Resource> optionalTarget = this.resourceRegistry.getResource(ref.targetResource);
            if (!optionalTarget.isPresent() || !optionalTarget.get().hasItem() || !optionalTarget.get().getItem().isInSpine()) continue;
            Resource res = optionalTarget.get();
            int targetSpinePosition = res.getItem().getSpinePosition();
            if (targetSpinePosition < lastSpinePosition) {
                String orderContext = LocalizedMessages.getInstance(this.locale).getSuggestion(MessageId.NAV_011, "spine");
                if (ref.type == Reference.Type.OVERLAY_TEXT_LINK) {
                    this.report.message(MessageId.MED_015, ref.location, this.container.relativize(ref.url), orderContext);
                } else {
                    this.report.message(MessageId.NAV_011, ref.location, ref.type == Reference.Type.NAV_TOC_LINK ? "toc" : "page-list", this.container.relativize(ref.url), orderContext);
                }
                lastSpinePosition = targetSpinePosition;
                lastAnchorPosition = -1;
                continue;
            }
            if (targetSpinePosition > lastSpinePosition) {
                lastSpinePosition = targetSpinePosition;
                lastAnchorPosition = -1;
            }
            if ((targetAnchorPosition = this.resourceRegistry.getIDPosition((fragment = URLFragment.parse(ref.url, res.getMimeType())).getId(), res)) <= -1) continue;
            if (targetAnchorPosition < lastAnchorPosition) {
                String orderContext = LocalizedMessages.getInstance(this.locale).getSuggestion(MessageId.NAV_011, "document");
                if (ref.type == Reference.Type.OVERLAY_TEXT_LINK) {
                    this.report.message(MessageId.MED_015, ref.location, this.container.relativize(ref.url), orderContext);
                } else {
                    this.report.message(MessageId.NAV_011, ref.location, ref.type == Reference.Type.NAV_TOC_LINK ? "toc" : "page-list", this.container.relativize(ref.url), orderContext);
                }
            }
            lastAnchorPosition = targetAnchorPosition;
        }
    }
}

