/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runner;

import io.cucumber.core.exception.UnrecoverableExceptions;
import io.cucumber.core.runner.TestAbortedExceptions;
import java.util.function.Predicate;

final class ThrowableCollector {
    private Throwable throwable;
    private final Predicate<Throwable> isTestAbortedException = TestAbortedExceptions.createIsTestAbortedExceptionPredicate();

    ThrowableCollector() {
    }

    void execute(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable t) {
            UnrecoverableExceptions.rethrowIfUnrecoverable(t);
            this.add(t);
        }
    }

    private void add(Throwable throwable) {
        if (this.throwable == null) {
            this.throwable = throwable;
        } else if (this.isTestAbortedException(this.throwable) && !this.isTestAbortedException(throwable)) {
            throwable.addSuppressed(this.throwable);
            this.throwable = throwable;
        } else if (this.throwable != throwable) {
            this.throwable.addSuppressed(throwable);
        }
    }

    private boolean isTestAbortedException(Throwable throwable) {
        return this.isTestAbortedException.test(throwable);
    }

    Throwable getThrowable() {
        return this.throwable;
    }
}

