/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.edge.mindmapmode;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.freeplane.core.ui.ColorTracker;
import org.freeplane.core.ui.components.JRestrictedSizeScrollPane;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.ColorUtils;

public class ColorListEditorPanelBuilder {
    private final JPanel panel;
    private final CellConstraints cc;
    private final FormLayout formlayout;
    private final List<Color> colors = new ArrayList<Color>();
    private final List<RowButtons> buttons;
    private static final Font BUTTON_FONT;
    private static final String MOVE_DOWN = "2";
    private static final String MOVE_UP = "1";
    private static final String DELETE = "3";
    private static final String ADD = "4";

    public static void main(String[] args) {
        ArrayList<Color> colorList = new ArrayList<Color>(100);
        for (int i = 0; i < 100; ++i) {
            colorList.add(Color.WHITE);
        }
        JComponent panel = new ColorListEditorPanelBuilder(colorList).getPanel();
        JRestrictedSizeScrollPane jscrollpane = new JRestrictedSizeScrollPane((Component)panel);
        UITools.setScrollbarIncrement((JScrollPane)jscrollpane);
        jscrollpane.setVerticalScrollBarPolicy(22);
        jscrollpane.setHorizontalScrollBarPolicy(31);
        jscrollpane.setMaximumSize(new Dimension(Integer.MAX_VALUE, 600));
        JOptionPane.showConfirmDialog(null, jscrollpane);
    }

    public ColorListEditorPanelBuilder(List<Color> colors) {
        this.panel = new JPanel();
        this.panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.formlayout = new FormLayout("FILL:DEFAULT:NONE,FILL:4DLU:NONE,FILL:108DLU:NONE,FILL:4DLU:NONE,FILL:DEFAULT:NONE,FILL:4DLU:NONE,FILL:DEFAULT:NONE,FILL:4DLU:NONE,FILL:DEFAULT:NONE,FILL:4DLU:NONE,FILL:DEFAULT:NONE", "");
        this.cc = new CellConstraints();
        this.formlayout.setColumnGroups((int[][])new int[][]{{5, 7, 9, 11}});
        this.panel.setLayout((LayoutManager)this.formlayout);
        this.buttons = new ArrayList<RowButtons>();
        this.colors.clear();
        this.colors.addAll(colors);
        this.addAddColorButton();
        this.addColorButtons();
    }

    public JComponent getPanel() {
        return this.panel;
    }

    private void addColorButtons() {
        for (Color c : this.colors) {
            this.addColorButtonRow();
        }
    }

    private void addColorButtonRow() {
        RowButtons rowButtons = new RowButtons(this.buttons.size());
        this.buttons.add(rowButtons);
    }

    private void addAddColorButton() {
        this.formlayout.appendRow(RowSpec.decode((String)"CENTER:DEFAULT:NONE"));
        JButton addColor = new JButton();
        addColor.addActionListener(new ColorAdder(0));
        addColor.setName("addColor");
        addColor.setFont(BUTTON_FONT);
        addColor.setText(ADD);
        this.panel.add((Component)addColor, this.cc.xy(11, 1));
    }

    public List<Color> getColors() {
        return this.colors;
    }

    static {
        try (InputStream fontResource = ColorListEditorPanelBuilder.class.getResourceAsStream("/fonts/listcontrols.ttf");){
            float fontSize = Math.round(UITools.FONT_SCALE_FACTOR * 14.0f);
            BUTTON_FONT = Font.createFont(0, fontResource).deriveFont(fontSize);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class RowButtons {
        private final JLabel rowNumber;
        private final JButton pickColor;
        private final JButton moveColorUp;
        private final JButton addNextColor;
        private final JButton deleteColor;
        private final JButton moveColorDown;
        private final int index;

        public RowButtons(int index) {
            this.rowNumber = new JLabel(Integer.toString(index) + ":");
            this.rowNumber.setHorizontalAlignment(4);
            this.pickColor = new JButton();
            this.moveColorUp = new JButton();
            this.moveColorDown = new JButton();
            this.addNextColor = new JButton();
            this.deleteColor = new JButton();
            this.index = index;
            this.initialize();
        }

        private void initialize() {
            this.rowNumber.setName("rowNumber");
            this.initializePickColorButton();
            this.initializeMoveColorUpButton();
            this.initializeMoveColorDownButton();
            this.initializeAddButton();
            this.initializeDeleteButton();
            this.appendRowsToPanel();
            this.addComponentsToPanel();
        }

        private void initializePickColorButton() {
            this.pickColor.setName("pickColor");
            this.pickColor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color newColor = ColorTracker.showCommonJColorChooserDialog((Component)RowButtons.this.pickColor, (String)"Pick color", (Color)((Color)ColorListEditorPanelBuilder.this.colors.get(RowButtons.this.index)), null);
                    if (newColor != null) {
                        ColorListEditorPanelBuilder.this.colors.set(RowButtons.this.index, newColor);
                        RowButtons.this.updatePickColorButton();
                        RowButtons.this.updateMoveColorDownButton();
                    }
                }
            });
            this.updatePickColorButton();
        }

        private void initializeMoveColorDownButton() {
            this.moveColorDown.setName("moveColorDown");
            this.moveColorDown.setFont(BUTTON_FONT);
            this.moveColorDown.setText(ColorListEditorPanelBuilder.MOVE_DOWN);
            this.moveColorDown.addActionListener(new ColorSwapper(1));
            this.updateMoveColorDownButton();
        }

        private void initializeMoveColorUpButton() {
            this.moveColorUp.setName("moveColorUp");
            this.moveColorUp.setFont(BUTTON_FONT);
            this.moveColorUp.setText(ColorListEditorPanelBuilder.MOVE_UP);
            this.moveColorUp.addActionListener(new ColorSwapper(-1));
            this.moveColorUp.setVisible(this.index > 0);
        }

        private void initializeAddButton() {
            this.addNextColor.setName("addNextColor");
            this.addNextColor.setFont(BUTTON_FONT);
            this.addNextColor.setText(ColorListEditorPanelBuilder.ADD);
            this.addNextColor.addActionListener(new ColorAdder(this.index + 1));
        }

        private void initializeDeleteButton() {
            this.deleteColor.setName("deleteColor");
            this.deleteColor.setFont(BUTTON_FONT);
            this.deleteColor.setText(ColorListEditorPanelBuilder.DELETE);
            this.deleteColor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColorListEditorPanelBuilder.this.colors.remove(RowButtons.this.index);
                    for (int i = RowButtons.this.index; i < ColorListEditorPanelBuilder.this.colors.size(); ++i) {
                        RowButtons r = (RowButtons)ColorListEditorPanelBuilder.this.buttons.get(i);
                        r.updatePickColorButton();
                    }
                    if (ColorListEditorPanelBuilder.this.colors.size() > 0) {
                        RowButtons r = (RowButtons)ColorListEditorPanelBuilder.this.buttons.get(ColorListEditorPanelBuilder.this.colors.size() - 1);
                        r.updateMoveColorDownButton();
                    }
                    int lastButtonRowIndex = ColorListEditorPanelBuilder.this.buttons.size() - 1;
                    ((RowButtons)ColorListEditorPanelBuilder.this.buttons.get(lastButtonRowIndex)).removeFromPanel();
                    ColorListEditorPanelBuilder.this.buttons.remove(lastButtonRowIndex);
                    ColorListEditorPanelBuilder.this.panel.repaint();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                        }
                    });
                }
            });
        }

        private void addComponentsToPanel() {
            int row = this.getFormRow();
            ColorListEditorPanelBuilder.this.panel.add((Component)this.rowNumber, ColorListEditorPanelBuilder.this.cc.xy(1, row));
            ColorListEditorPanelBuilder.this.panel.add((Component)this.pickColor, ColorListEditorPanelBuilder.this.cc.xy(3, row));
            ColorListEditorPanelBuilder.this.panel.add((Component)this.moveColorUp, ColorListEditorPanelBuilder.this.cc.xy(5, row));
            ColorListEditorPanelBuilder.this.panel.add((Component)this.moveColorDown, ColorListEditorPanelBuilder.this.cc.xy(7, row));
            ColorListEditorPanelBuilder.this.panel.add((Component)this.deleteColor, ColorListEditorPanelBuilder.this.cc.xy(9, row));
            ColorListEditorPanelBuilder.this.panel.add((Component)this.addNextColor, ColorListEditorPanelBuilder.this.cc.xy(11, row));
        }

        private void appendRowsToPanel() {
            ColorListEditorPanelBuilder.this.formlayout.appendRow(RowSpec.decode((String)"CENTER:4DLU:NONE"));
            ColorListEditorPanelBuilder.this.formlayout.appendRow(RowSpec.decode((String)"CENTER:DEFAULT:NONE"));
        }

        public void scrollToVisible() {
            this.pickColor.scrollRectToVisible(new Rectangle(0, 0, this.pickColor.getWidth(), this.pickColor.getHeight()));
        }

        private int getFormRow() {
            return this.index * 2 + 3;
        }

        private void updateMoveColorDownButton() {
            this.moveColorDown.setVisible(this.index < ColorListEditorPanelBuilder.this.colors.size() - 1);
        }

        private void updatePickColorButton() {
            Color color = (Color)ColorListEditorPanelBuilder.this.colors.get(this.index);
            this.pickColor.setBackground(ColorUtils.makeNonTransparent((Color)color));
            Color textColor = UITools.getTextColorForBackground((Color)color);
            this.pickColor.setForeground(textColor);
            this.pickColor.setText(ColorUtils.colorToString((Color)color));
        }

        private void removeFromPanel() {
            ColorListEditorPanelBuilder.this.panel.remove(this.rowNumber);
            ColorListEditorPanelBuilder.this.panel.remove(this.pickColor);
            ColorListEditorPanelBuilder.this.panel.remove(this.moveColorUp);
            ColorListEditorPanelBuilder.this.panel.remove(this.moveColorDown);
            ColorListEditorPanelBuilder.this.panel.remove(this.addNextColor);
            ColorListEditorPanelBuilder.this.panel.remove(this.deleteColor);
            int row = this.getFormRow();
            ColorListEditorPanelBuilder.this.formlayout.removeRow(row);
            ColorListEditorPanelBuilder.this.formlayout.removeRow(row - 1);
        }

        private class ColorSwapper
        implements ActionListener {
            private final int direction;

            public ColorSwapper(int direction) {
                this.direction = direction;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Color movedColor = (Color)ColorListEditorPanelBuilder.this.colors.get(RowButtons.this.index);
                int swappedColorIndex = RowButtons.this.index + this.direction;
                Color otherColorColor = (Color)ColorListEditorPanelBuilder.this.colors.get(swappedColorIndex);
                ColorListEditorPanelBuilder.this.colors.set(RowButtons.this.index, otherColorColor);
                ColorListEditorPanelBuilder.this.colors.set(swappedColorIndex, movedColor);
                RowButtons.this.updatePickColorButton();
                RowButtons.this.updateMoveColorDownButton();
                RowButtons r = (RowButtons)ColorListEditorPanelBuilder.this.buttons.get(swappedColorIndex);
                r.updatePickColorButton();
                r.updateMoveColorDownButton();
            }
        }
    }

    private class ColorAdder
    implements ActionListener {
        private final int index;

        public ColorAdder(int index) {
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Color color = this.index > 0 ? (Color)ColorListEditorPanelBuilder.this.colors.get(this.index - 1) : Color.GRAY;
            ColorListEditorPanelBuilder.this.colors.add(this.index, color);
            ColorListEditorPanelBuilder.this.addColorButtonRow();
            for (int i = this.index; i < ColorListEditorPanelBuilder.this.colors.size() - 1; ++i) {
                RowButtons r = (RowButtons)ColorListEditorPanelBuilder.this.buttons.get(i);
                r.updatePickColorButton();
            }
            if (ColorListEditorPanelBuilder.this.colors.size() >= 2) {
                ((RowButtons)ColorListEditorPanelBuilder.this.buttons.get(ColorListEditorPanelBuilder.this.colors.size() - 2)).updateMoveColorDownButton();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((RowButtons)ColorListEditorPanelBuilder.this.buttons.get(ColorAdder.this.index)).scrollToVisible();
                }
            });
        }
    }
}

