/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.note.mindmapmode;

import java.awt.Window;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.collection.OptionalReference;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.note.mindmapmode.MNoteController;
import org.freeplane.features.text.mindmapmode.EditNodeBase;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.features.text.mindmapmode.NoteTextEditorHolder;

class NoteDialogStarter {
    private static final Pattern HTML_HEAD = Pattern.compile("\\s*<head>.*</head>", 32);

    NoteDialogStarter() {
    }

    void editNoteInDialog(NodeModel nodeModel) {
        NoteTextEditorHolder editorHolder = (NoteTextEditorHolder)nodeModel.getExtension(NoteTextEditorHolder.class);
        if (editorHolder != null) {
            editorHolder.activate();
            return;
        }
        Controller controller = Controller.getCurrentController();
        NoteModel note = NoteModel.getNote((NodeModel)nodeModel);
        if (note == null) {
            note = new NoteModel();
        }
        NoteEditor editControl = new NoteEditor(nodeModel);
        Window window = SwingUtilities.getWindowAncestor(controller.getMapViewManager().getMapViewComponent());
        EditNodeBase editor = MTextController.getController().createEditor(nodeModel, note, note.getTextOr(""), editControl, false, true, true);
        editor.show(window);
    }

    private void setHtmlText(NodeModel node, String newText) {
        String body = HTML_HEAD.matcher(newText).replaceFirst("");
        MNoteController noteController = MNoteController.getController();
        String trimmed = body.replaceFirst("\\s+$", "");
        if (HtmlUtils.isEmpty((String)trimmed)) {
            noteController.setNoteText(node, null);
        } else {
            noteController.setNoteText(node, trimmed);
        }
    }

    private class NoteEditor
    implements EditNodeBase.IEditControl {
        private final OptionalReference<NodeModel> nodeModel;

        private NoteEditor(NodeModel nodeModel) {
            this.nodeModel = new OptionalReference((Object)nodeModel);
        }

        @Override
        public void cancel() {
        }

        @Override
        public void ok(String newText) {
            this.nodeModel.ifPresent(x -> NoteDialogStarter.this.setHtmlText(x, newText));
        }

        @Override
        public void split(String newText, int position) {
        }

        @Override
        public boolean canSplit() {
            return false;
        }

        @Override
        public EditNodeBase.EditedComponent getEditType() {
            return EditNodeBase.EditedComponent.NOTE;
        }
    }
}

