/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode.styleeditorpanel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormSpecs;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import org.freeplane.api.swing.JFileChooser;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.core.ui.components.InfoArea;
import org.freeplane.core.ui.components.JComboBoxFactory;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.textchanger.TranslatedElement;
import org.freeplane.core.ui.textchanger.TranslatedElementFactory;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.edge.AutomaticEdgeColor;
import org.freeplane.features.edge.AutomaticEdgeColorHook;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.edge.mindmapmode.MEdgeController;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.AutomaticLayout;
import org.freeplane.features.styles.AutomaticLayoutController;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.LogicalStyleModel;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.styles.mindmapmode.MLogicalStyleController;
import org.freeplane.features.styles.mindmapmode.MUIFactory;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.RevertingProperty;
import org.freeplane.features.url.mindmapmode.TemplateManager;
import org.freeplane.view.swing.features.filepreview.MindMapPreviewWithOptions;

class StyleControlGroup
implements ControlGroup {
    private static final int LEFT_MARGIN = (int)(15.0f * UITools.FONT_SCALE_FACTOR);
    private static final int GAP = (int)(6.0f * UITools.FONT_SCALE_FACTOR);
    private static final String CHOOSE_TEMPLATE = "choose_template";
    private static final String MAKE_FORMATTING_DEFAULT = "make_formatting_default";
    private static final String FOR_ALL_NODES_OF_STYLE = "for_all_nodes_of_style";
    private static final String FOR_THIS_MAP = "changes_style_for_this_map";
    private static final String FOR_TEMPLATE = "changes_template_style";
    private static final String FOR_TEMPLATE_TOOLTIP = "changes_template_style.tooltip";
    private boolean internalChange;
    private RevertingProperty mSetStyle;
    private JButton mNodeStyleButton;
    private JButton mMapStyleButton;
    private JLabel styleNameLabel;
    private JRadioButton redefinesStyleForCurrentMapOnly;
    private JRadioButton redefinesStyleForCurrentMapAndTemplate;
    private JTextArea redefinedTemplate;
    private JButton chooseTemplateButton;
    private final boolean addStyleBox;
    private JComboBox mAutomaticLayoutComboBox;
    private JComboBox mAutomaticEdgeColorComboBox;
    private JButton mEditEdgeColorsBtn;
    private Container mStyleBox;
    private final MUIFactory uiFactory;
    private final ModeController modeController;
    private final float fontSize;
    private static final TranslatedObject AUTOMATIC_LAYOUT_DISABLED = new TranslatedObject("automatic_layout_disabled");

    public StyleControlGroup(boolean addStyleBox, MUIFactory uiFactory, ModeController modeController, float fontSize) {
        this.addStyleBox = addStyleBox;
        this.uiFactory = uiFactory;
        this.modeController = modeController;
        this.fontSize = fontSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStyle(NodeModel node, boolean canEdit) {
        this.internalChange = true;
        try {
            IExtension extension;
            LogicalStyleController logicalStyleController = LogicalStyleController.getController();
            if (this.addStyleBox) {
                boolean isStyleSet = LogicalStyleModel.getStyle((NodeModel)node) != null;
                this.mSetStyle.setValue(isStyleSet);
                this.setStyleList(this.mMapStyleButton, logicalStyleController.getMapStyleNames(node, "\n"));
                IStyle firstStyle = logicalStyleController.getFirstStyle(node);
                String styleName = TextUtils.format((String)FOR_ALL_NODES_OF_STYLE, (Object[])new Object[]{firstStyle.toString()});
                if (!this.styleNameLabel.getText().equals(styleName)) {
                    this.styleNameLabel.setText(styleName);
                }
                this.updateTemplateName(node.getMap());
            }
            this.setStyleList(this.mNodeStyleButton, logicalStyleController.getNodeStyleNames(node, "\n"));
            if (this.mAutomaticLayoutComboBox != null) {
                AutomaticLayoutController al = (AutomaticLayoutController)this.modeController.getExtension(AutomaticLayoutController.class);
                extension = al.getExtension(node);
                if (extension == null) {
                    this.mAutomaticLayoutComboBox.setSelectedItem(AUTOMATIC_LAYOUT_DISABLED);
                } else {
                    this.mAutomaticLayoutComboBox.setSelectedIndex(((AutomaticLayout)extension).ordinal());
                }
            }
            if (this.mAutomaticEdgeColorComboBox != null) {
                AutomaticEdgeColorHook al = (AutomaticEdgeColorHook)this.modeController.getExtension(AutomaticEdgeColorHook.class);
                extension = (AutomaticEdgeColor)al.getExtension(node);
                if (extension == null) {
                    this.mAutomaticEdgeColorComboBox.setSelectedItem(AUTOMATIC_LAYOUT_DISABLED);
                    this.mEditEdgeColorsBtn.setEnabled(false);
                } else {
                    this.mAutomaticEdgeColorComboBox.setSelectedIndex(extension.rule.ordinal());
                    this.mEditEdgeColorsBtn.setEnabled(canEdit);
                }
            }
        }
        finally {
            this.internalChange = false;
        }
    }

    private void setStyleList(JButton btn, String styles) {
        if ("".equals(styles)) {
            btn.setToolTipText(null);
            btn.setText(" ");
            return;
        }
        btn.setToolTipText(HtmlUtils.plainToHTML((String)styles));
        String text = styles.replaceAll("\n", ", ");
        btn.setText(text);
    }

    @Override
    public void addControlGroup(DefaultFormBuilder formBuilder) {
        if (this.addStyleBox) {
            this.addStyleBox(formBuilder);
        }
        this.mNodeStyleButton = this.addButton(formBuilder, "actual_node_styles", (ActionListener)this.modeController.getAction("ManageNodeConditionalStylesAction"));
        if (this.addStyleBox) {
            this.mMapStyleButton = this.addButton(formBuilder, "actual_map_styles", (ActionListener)this.modeController.getAction("ManageConditionalStylesAction"));
            this.addAutomaticLayout(formBuilder);
            this.styleNameLabel = new JLabel();
            this.styleNameLabel.setAlignmentX(0.0f);
            this.redefinesStyleForCurrentMapOnly = new JRadioButton();
            this.redefinesStyleForCurrentMapOnly.setSelected(true);
            this.redefinesStyleForCurrentMapOnly.setText(TextUtils.getRawText((String)FOR_THIS_MAP));
            this.redefinesStyleForCurrentMapOnly.setAlignmentX(0.0f);
            this.redefinesStyleForCurrentMapAndTemplate = new JRadioButton();
            this.redefinesStyleForCurrentMapAndTemplate.setText(TextUtils.getText((String)FOR_TEMPLATE));
            this.redefinesStyleForCurrentMapAndTemplate.setAlignmentX(0.0f);
            ButtonGroup redefineStyleButtonGroup = new ButtonGroup();
            redefineStyleButtonGroup.add(this.redefinesStyleForCurrentMapOnly);
            redefineStyleButtonGroup.add(this.redefinesStyleForCurrentMapAndTemplate);
            Box styleAndButtonBox = Box.createVerticalBox();
            Box radioButtonBox = Box.createVerticalBox();
            radioButtonBox.setBorder(BorderFactory.createEmptyBorder(0, LEFT_MARGIN * 2, 0, 0));
            radioButtonBox.add(this.redefinesStyleForCurrentMapOnly);
            radioButtonBox.add(this.redefinesStyleForCurrentMapAndTemplate);
            radioButtonBox.setAlignmentX(0.0f);
            radioButtonBox.setBorder(BorderFactory.createEmptyBorder(0, 0, GAP, 0));
            JButton redefineStyleBtn = TranslatedElementFactory.createButton((String)"ApplyAction.text");
            redefineStyleBtn.addActionListener(e -> {
                NodeModel node = Controller.getCurrentController().getSelection().getSelected();
                MapStyle.getController().redefineStyle(node, this.redefinesStyleForCurrentMapAndTemplate.isSelected());
            });
            radioButtonBox.setBorder(BorderFactory.createEmptyBorder(0, LEFT_MARGIN * 2, 0, 0));
            styleAndButtonBox.add(this.padded(this.styleNameLabel));
            styleAndButtonBox.add(this.padded(redefineStyleBtn));
            styleAndButtonBox.add(radioButtonBox);
            this.redefinedTemplate = new InfoArea();
            this.redefinedTemplate.setColumns(80);
            this.redefinedTemplate.setLineWrap(true);
            this.redefinedTemplate.setWrapStyleWord(false);
            this.redefinedTemplate.setBorder(BorderFactory.createEmptyBorder());
            this.redefinedTemplate.setFont(this.redefinedTemplate.getFont().deriveFont(2));
            this.redefinedTemplate.setAlignmentX(0.0f);
            styleAndButtonBox.add(this.padded(this.redefinedTemplate));
            this.chooseTemplateButton = new JButton(TextUtils.getRawText((String)CHOOSE_TEMPLATE));
            this.chooseTemplateButton.setAlignmentX(0.0f);
            this.chooseTemplateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapModel map = Controller.getCurrentController().getMap();
                    if (map == null) {
                        return;
                    }
                    MindMapPreviewWithOptions previewWithOptions = MindMapPreviewWithOptions.createFileOpenDialogAndOptions((String)TextUtils.getText((String)"select_associated_template"));
                    JFileChooser fileChooser = previewWithOptions.getFileChooser();
                    int returnVal = fileChooser.showOpenDialog((Component)UITools.getCurrentFrame());
                    if (returnVal != 0) {
                        return;
                    }
                    File file = fileChooser.getSelectedFile();
                    try {
                        if (file == null || !file.exists()) {
                            return;
                        }
                        if (map.getFile() != null && file.getCanonicalFile().equals(map.getFile().getCanonicalFile())) {
                            MapStyle.getController().setProperty(map, "associatedTemplateLocation", null);
                            return;
                        }
                    }
                    catch (IOException e1) {
                        LogUtils.warn((Throwable)e1);
                        return;
                    }
                    MapStyle.getController().setProperty(map, "associatedTemplateLocation", TemplateManager.INSTANCE.normalizeTemplateLocation(file.toURI()).toString());
                }
            });
            styleAndButtonBox.add(this.padded(this.chooseTemplateButton));
            UITools.addTitledBorder((JComponent)styleAndButtonBox, (String)TextUtils.getRawText((String)MAKE_FORMATTING_DEFAULT), (float)this.fontSize);
            formBuilder.append((Component)styleAndButtonBox, formBuilder.getColumnCount());
            formBuilder.nextLine();
            MapController mapController = Controller.getCurrentModeController().getMapController();
            mapController.addMapChangeListener(new IMapChangeListener(){

                public void mapChanged(MapChangeEvent event) {
                    if ("associatedTemplateLocation".equals(event.getProperty()) && event.getMap().equals(Controller.getCurrentController().getMap())) {
                        StyleControlGroup.this.updateTemplateName(event.getMap());
                    }
                }
            });
        }
    }

    private JComponent padded(Component component) {
        Box box = Box.createHorizontalBox();
        box.setAlignmentX(0.0f);
        box.add(Box.createHorizontalStrut(LEFT_MARGIN));
        box.add(component);
        return box;
    }

    private void updateTemplateName(MapModel map) {
        String templateLocation = MapStyle.getController().getProperty(map, "associatedTemplateLocation");
        String templateDescription = TemplateManager.INSTANCE.describeNormalizedLocation(templateLocation);
        if (!templateDescription.equals(this.redefinedTemplate.getText())) {
            this.redefinedTemplate.setText(templateDescription);
        }
        this.redefinesStyleForCurrentMapAndTemplate.setToolTipText(TextUtils.format((String)FOR_TEMPLATE_TOOLTIP, (Object[])new Object[]{templateDescription}));
        if (templateLocation == null) {
            this.redefinesStyleForCurrentMapOnly.setSelected(true);
        }
        this.redefinesStyleForCurrentMapAndTemplate.setEnabled(templateLocation != null);
    }

    private JButton addButton(DefaultFormBuilder formBuilder, String label, ActionListener action) {
        JButton button = this.addButton(formBuilder, action);
        TranslatedElement.BORDER.setKey((JComponent)button, label);
        String labelText = TextUtils.getText((String)label);
        UITools.addTitledBorder((JComponent)button, (String)labelText, (float)this.fontSize);
        return button;
    }

    private JButton addButton(DefaultFormBuilder formBuilder, ActionListener action) {
        JButton button = new JButton();
        button.setHorizontalAlignment(2);
        this.addComponent(formBuilder, button);
        button.addActionListener(action);
        return button;
    }

    private void addComponent(DefaultFormBuilder formBuilder, Component component) {
        formBuilder.append(component, formBuilder.getColumnCount());
        formBuilder.nextLine();
    }

    private void addStyleBox(DefaultFormBuilder formBuilder) {
        this.mStyleBox = this.uiFactory.createStyleBox();
        this.mSetStyle = new RevertingProperty();
        StyleChangeListener listener = new StyleChangeListener();
        this.mSetStyle.addPropertyChangeListener(listener);
        formBuilder.append((Component)new JLabel(TextUtils.getText((String)"style")));
        formBuilder.append((Component)this.mStyleBox);
        this.mSetStyle.appendToForm(formBuilder);
        formBuilder.nextLine();
    }

    private void addAutomaticLayout(DefaultFormBuilder formBuilder) {
        this.addAutomaticLayoutControls(formBuilder);
        this.addEdgeColoringControls(formBuilder);
    }

    private void addAutomaticLayoutControls(DefaultFormBuilder formBuilder) {
        Object[] automaticLayoutTypes = TranslatedObject.fromEnum(AutomaticLayout.class);
        this.mAutomaticLayoutComboBox = JComboBoxFactory.create((Object[])automaticLayoutTypes);
        DefaultComboBoxModel automaticLayoutComboBoxModel = (DefaultComboBoxModel)this.mAutomaticLayoutComboBox.getModel();
        automaticLayoutComboBoxModel.addElement(AUTOMATIC_LAYOUT_DISABLED);
        automaticLayoutComboBoxModel.setSelectedItem(AUTOMATIC_LAYOUT_DISABLED);
        this.mAutomaticLayoutComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StyleControlGroup.this.internalChange) {
                    return;
                }
                ModeController modeController = Controller.getCurrentModeController();
                AutomaticLayoutController al = (AutomaticLayoutController)modeController.getExtension(AutomaticLayoutController.class);
                TranslatedObject selectedItem = (TranslatedObject)StyleControlGroup.this.mAutomaticLayoutComboBox.getSelectedItem();
                al.undoableDeactivateHook(Controller.getCurrentController().getMap().getRootNode());
                if (!selectedItem.equals((Object)AUTOMATIC_LAYOUT_DISABLED)) {
                    al.undoableActivateHook(Controller.getCurrentController().getMap().getRootNode(), (IExtension)((AutomaticLayout)selectedItem.getObject()));
                }
            }
        });
        this.appendLabeledComponent(formBuilder, "automatic_layout", this.mAutomaticLayoutComboBox);
    }

    private void addEdgeColoringControls(DefaultFormBuilder formBuilder) {
        Object[] automaticLayoutTypes = TranslatedObject.fromEnum((String)(AutomaticEdgeColor.class.getSimpleName() + "."), AutomaticEdgeColor.Rule.class);
        this.mAutomaticEdgeColorComboBox = JComboBoxFactory.create((Object[])automaticLayoutTypes);
        DefaultComboBoxModel automaticEdgeColorComboBoxModel = (DefaultComboBoxModel)this.mAutomaticEdgeColorComboBox.getModel();
        automaticEdgeColorComboBoxModel.addElement(AUTOMATIC_LAYOUT_DISABLED);
        automaticEdgeColorComboBoxModel.setSelectedItem(AUTOMATIC_LAYOUT_DISABLED);
        this.mAutomaticEdgeColorComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StyleControlGroup.this.internalChange) {
                    return;
                }
                ModeController modeController = Controller.getCurrentModeController();
                AutomaticEdgeColorHook hook = (AutomaticEdgeColorHook)modeController.getExtension(AutomaticEdgeColorHook.class);
                TranslatedObject selectedItem = (TranslatedObject)StyleControlGroup.this.mAutomaticEdgeColorComboBox.getSelectedItem();
                MapModel map = Controller.getCurrentController().getMap();
                AutomaticEdgeColor oldExtension = (AutomaticEdgeColor)hook.getMapHook(map);
                int colorCount = oldExtension == null ? 0 : oldExtension.getColorCounter();
                NodeModel rootNode = map.getRootNode();
                hook.undoableDeactivateHook(rootNode);
                if (!selectedItem.equals((Object)AUTOMATIC_LAYOUT_DISABLED)) {
                    AutomaticEdgeColor newExtension = new AutomaticEdgeColor((AutomaticEdgeColor.Rule)selectedItem.getObject(), colorCount);
                    hook.undoableActivateHook(rootNode, (IExtension)newExtension);
                }
            }
        });
        this.appendLabeledComponent(formBuilder, "AutomaticEdgeColorHookAction.text", this.mAutomaticEdgeColorComboBox);
        this.mEditEdgeColorsBtn = TranslatedElementFactory.createButton((String)"editEdgeColors");
        this.mEditEdgeColorsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MEdgeController edgeController = (MEdgeController)StyleControlGroup.this.modeController.getExtension(EdgeController.class);
                edgeController.editEdgeColorConfiguration(Controller.getCurrentController().getMap());
            }
        });
        formBuilder.appendLineGapRow();
        formBuilder.nextLine();
        formBuilder.appendRow(FormSpecs.PREF_ROWSPEC);
        formBuilder.setColumn(1);
        formBuilder.append((Component)this.mEditEdgeColorsBtn, formBuilder.getColumnCount());
        formBuilder.nextLine();
    }

    private void appendLabeledComponent(DefaultFormBuilder formBuilder, String labelKey, Component component) {
        String text = TextUtils.getText((String)labelKey);
        JLabel label = new JLabel(text);
        TranslatedElement.TEXT.setKey((JComponent)label, labelKey);
        formBuilder.append((Component)label, 1);
        formBuilder.append(component, 3);
        formBuilder.nextLine();
    }

    private class StyleChangeListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (StyleControlGroup.this.internalChange) {
                return;
            }
            RevertingProperty isSet = (RevertingProperty)((Object)evt.getSource());
            MLogicalStyleController styleController = (MLogicalStyleController)LogicalStyleController.getController();
            if (isSet.getBooleanValue()) {
                styleController.setStyle((IStyle)StyleControlGroup.this.uiFactory.getStyles().getSelectedItem());
            } else {
                styleController.setStyle(null);
            }
        }
    }
}

