/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer.resolvers;

import com.tngtech.archunit.ArchConfiguration;
import com.tngtech.archunit.Internal;
import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ArchUnitException;
import com.tngtech.archunit.base.ClassLoaders;
import com.tngtech.archunit.base.MayResolveTypesViaReflection;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.importer.resolvers.ClassResolverFromClasspath;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

@PublicAPI(usage=PublicAPI.Usage.INHERITANCE)
public interface ClassResolver {
    public void setClassUriImporter(ClassUriImporter var1);

    public Optional<JavaClass> tryResolve(String var1);

    @Internal
    public static final class Factory {
        public ClassResolver create() {
            Optional<ClassResolver> resolver = this.getExplicitlyConfiguredClassResolver();
            if (resolver.isPresent()) {
                return resolver.get();
            }
            boolean resolveFromClasspath = ArchConfiguration.get().resolveMissingDependenciesFromClassPath();
            return resolveFromClasspath ? new ClassResolverFromClasspath() : new NoOpClassResolver();
        }

        private Optional<ClassResolver> getExplicitlyConfiguredClassResolver() {
            Optional<String> resolverClassName = ArchConfiguration.get().getClassResolver();
            if (!resolverClassName.isPresent()) {
                return Optional.empty();
            }
            Class<?> resolverClass = this.classForName(resolverClassName.get());
            List<String> args = ArchConfiguration.get().getClassResolverArguments();
            ClassResolverProvider classResolverProvider = this.createProvider(resolverClass, args);
            return Optional.of(classResolverProvider.get());
        }

        @MayResolveTypesViaReflection(reason="Loading a ClassResolver implementation is independent of the actual import")
        private Class<?> classForName(String resolverClassName) {
            try {
                return ClassLoaders.loadClass(resolverClassName);
            }
            catch (ClassNotFoundException e) {
                throw ArchUnitException.ClassResolverConfigurationException.onLoadingClass(resolverClassName, e);
            }
        }

        private ClassResolverProvider createProvider(Class<?> resolverClass, final List<String> args) {
            final Optional<Constructor<?>> listConstructor = this.tryGetListConstructor(resolverClass);
            if (listConstructor.isPresent()) {
                return new ClassResolverProvider(this.instantiationException(listConstructor.get(), args)){

                    @Override
                    ClassResolver tryGet() throws Exception {
                        return (ClassResolver)((Constructor)listConstructor.get()).newInstance(args);
                    }
                };
            }
            if (!args.isEmpty()) {
                throw ArchUnitException.ClassResolverConfigurationException.onWrongConstructor(resolverClass, args);
            }
            return this.tryCreateResolverProviderForDefaultConstructor(resolverClass, args);
        }

        private Function<Exception, ArchUnitException.ClassResolverConfigurationException> instantiationException(Constructor<?> constructor, List<String> args) {
            return cause -> ArchUnitException.ClassResolverConfigurationException.onInstantiation(constructor, args, cause);
        }

        private Optional<Constructor<?>> tryGetListConstructor(Class<?> resolverClass) {
            try {
                return Optional.of(this.accessibleConstructor(resolverClass, List.class));
            }
            catch (NoSuchMethodException e) {
                return Optional.empty();
            }
        }

        private ClassResolverProvider tryCreateResolverProviderForDefaultConstructor(Class<?> resolverClass, List<String> args) {
            Constructor<?> defaultConstructor;
            try {
                defaultConstructor = this.accessibleConstructor(resolverClass, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw ArchUnitException.ClassResolverConfigurationException.onWrongArguments(resolverClass, e);
            }
            return new ClassResolverProvider(this.instantiationException(defaultConstructor, args)){

                @Override
                ClassResolver tryGet() throws Exception {
                    return (ClassResolver)defaultConstructor.newInstance(new Object[0]);
                }
            };
        }

        private Constructor<?> accessibleConstructor(Class<?> clazz, Class<?> ... parameterTypes) throws NoSuchMethodException {
            Constructor<?> constructor;
            try {
                constructor = clazz.getDeclaredConstructor(parameterTypes);
            }
            catch (NoSuchMethodException e) {
                constructor = clazz.getConstructor(parameterTypes);
            }
            constructor.setAccessible(true);
            return constructor;
        }

        static class NoOpClassResolver
        implements ClassResolver {
            NoOpClassResolver() {
            }

            @Override
            public void setClassUriImporter(ClassUriImporter classUriImporter) {
            }

            @Override
            public Optional<JavaClass> tryResolve(String typeName) {
                return Optional.empty();
            }
        }

        private static abstract class ClassResolverProvider {
            private final Function<Exception, ArchUnitException.ClassResolverConfigurationException> onFailure;

            ClassResolverProvider(Function<Exception, ArchUnitException.ClassResolverConfigurationException> onFailure) {
                this.onFailure = onFailure;
            }

            ClassResolver get() {
                try {
                    return this.tryGet();
                }
                catch (Exception e) {
                    throw this.onFailure.apply(e);
                }
            }

            abstract ClassResolver tryGet() throws Exception;
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static interface ClassUriImporter {
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public Optional<JavaClass> tryImport(URI var1);
    }
}

