/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.EnumLength;
import org.apache.fop.fo.properties.EnumProperty;
import org.apache.fop.fo.properties.FixedLength;
import org.apache.fop.fo.properties.NumberProperty;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyMaker;

public abstract class LengthProperty
extends Property
implements Length,
Numeric {
    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public Numeric getNumeric() {
        return this;
    }

    @Override
    public Length getLength() {
        return this;
    }

    @Override
    public Object getObject() {
        return this;
    }

    public static class Maker
    extends PropertyMaker {
        public Maker(int propId) {
            super(propId);
        }

        @Override
        public Property convertProperty(Property p, PropertyList propertyList, FObj fo) throws PropertyException {
            if (p instanceof EnumProperty) {
                return new EnumLength(p);
            }
            if (p instanceof LengthProperty) {
                return p;
            }
            if (p instanceof NumberProperty) {
                float resolution = propertyList.getFObj().getUserAgent().getSourceResolution();
                return FixedLength.getInstance(p.getNumeric().getNumericValue(), "px", 72.0f / resolution);
            }
            Length val = p.getLength();
            if (val != null) {
                return (Property)((Object)val);
            }
            return this.convertPropertyDatatype(p, propertyList, fo);
        }
    }
}

