/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.io.FilePermission;
import java.net.SocketPermission;
import java.security.AllPermission;
import java.security.Permission;
import java.security.Permissions;
import java.util.Enumeration;

class ScriptingSecurityManager {
    private final Permissions permissions;
    private final boolean withoutFileRestriction;
    private final boolean withoutWriteRestriction;
    private final boolean withoutNetworkRestriction;
    private final boolean withoutExecRestriction;
    private static final Permission URL_PERMISSION = new SocketPermission("*", "connect");

    public ScriptingSecurityManager(boolean withoutFileRestriction, boolean withoutWriteRestriction, boolean withoutNetworkRestriction, boolean withoutExecRestriction) {
        this.withoutFileRestriction = withoutFileRestriction;
        this.withoutWriteRestriction = withoutWriteRestriction;
        this.withoutNetworkRestriction = withoutNetworkRestriction;
        this.withoutExecRestriction = withoutExecRestriction;
        this.permissions = new Permissions();
        if (withoutExecRestriction && withoutFileRestriction && withoutWriteRestriction && withoutNetworkRestriction) {
            this.permissions.add(new AllPermission());
        } else {
            if (withoutNetworkRestriction) {
                this.permissions.add(new SocketPermission("*", "connect,accept,listen,resolve"));
                this.permissions.add(new RuntimePermission("setFactory"));
            }
            if (withoutExecRestriction) {
                this.permissions.add(new FilePermission("<<ALL FILES>>", "execute"));
                this.permissions.add(new RuntimePermission("loadLibrary.*"));
            }
            if (withoutFileRestriction) {
                this.permissions.add(new FilePermission("<<ALL FILES>>", "read"));
                this.permissions.add(new RuntimePermission("readFileDescriptor"));
            }
            if (withoutWriteRestriction) {
                this.permissions.add(new RuntimePermission("writeFileDescriptor"));
                this.permissions.add(new FilePermission("<<ALL FILES>>", "write,delete"));
                this.permissions.add(new RuntimePermission("preferences"));
            }
        }
        this.permissions.setReadOnly();
        this.checkRequiredPermissions();
    }

    public boolean implies(Permission permission) {
        if (permission.getClass().getSimpleName().equals("URLPermission")) {
            return this.isAllowed(URL_PERMISSION);
        }
        return this.isAllowed(permission);
    }

    private boolean isAllowed(Permission permission) {
        boolean isAllowed = this.permissions.implies(permission);
        return isAllowed;
    }

    private void checkRequiredPermissions() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            Enumeration<Permission> permissionElements = this.permissions.elements();
            while (permissionElements.hasMoreElements()) {
                sm.checkPermission(permissionElements.nextElement());
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.withoutExecRestriction ? 1231 : 1237);
        result = 31 * result + (this.withoutFileRestriction ? 1231 : 1237);
        result = 31 * result + (this.withoutNetworkRestriction ? 1231 : 1237);
        result = 31 * result + (this.withoutWriteRestriction ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScriptingSecurityManager other = (ScriptingSecurityManager)obj;
        if (this.withoutExecRestriction != other.withoutExecRestriction) {
            return false;
        }
        if (this.withoutFileRestriction != other.withoutFileRestriction) {
            return false;
        }
        if (this.withoutNetworkRestriction != other.withoutNetworkRestriction) {
            return false;
        }
        return this.withoutWriteRestriction == other.withoutWriteRestriction;
    }
}

