/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import org.freeplane.core.ui.components.UITools;

class ArrowIcon
implements Icon {
    public static final ArrowIcon UP = new ArrowIcon(false);
    public static final ArrowIcon DOWN = new ArrowIcon(true);
    private final boolean down;
    private static final int ARROW_HEIGHT = (int)(5.0f * UITools.FONT_SCALE_FACTOR);
    private static final int ARROW_HALF_WIDTH = (int)(4.0f * UITools.FONT_SCALE_FACTOR);
    private static final int ICON_HEIGHT = ARROW_HEIGHT + 2;
    private static final int ICON_WIDTH = 1 + ARROW_HALF_WIDTH * 2 + 1;

    private ArrowIcon(boolean down) {
        this.down = down;
    }

    @Override
    public int getIconHeight() {
        return ICON_HEIGHT;
    }

    @Override
    public int getIconWidth() {
        return ICON_WIDTH;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int[] xs = new int[3];
        int[] ys = new int[3];
        xs[0] = 1 + ARROW_HALF_WIDTH;
        xs[1] = 1;
        xs[2] = xs[0] + ARROW_HALF_WIDTH;
        if (this.down) {
            ys[0] = 1 + ARROW_HEIGHT;
            ys[2] = 1;
            ys[1] = 1;
        } else {
            ys[0] = 1;
            ys[1] = ys[2] = 1 + ARROW_HEIGHT;
        }
        g.drawPolygon(xs, ys, 3);
    }
}

