/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.FocusManager;
import javax.swing.SwingUtilities;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.Compat;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.ui.MouseEventActor;
import org.freeplane.view.swing.ui.MouseTimerDelegate;
import org.freeplane.view.swing.ui.MovedMouseEventFilter;

public class NodeSelector
implements MouseTimerDelegate.ActionProvider {
    private static final String SELECTION_INSIDE_SAME_MAP = "selection_inside.same_map";
    private static final String SELECTION_INSIDE_SELECTED_WINDOW = "selection_inside.selected_window";
    private static final String SELECTION_INSIDE_ANY_MAP = "selection_inside.any_map";
    private static final String SELECTION_INSIDE_SELECTED_MAP_VIEW = "selection_inside.selected_map_view";
    private static final String MOUSE_OVER_SELECTION_INSIDE = "mouse_over_selection_inside";
    private static final String MOUSE_OVER_SELECTION = "mouse_over_selection";
    private static final String SELECTION_DISABLED = "disabled";
    private static final String SELECTION_DELAYED = "delayed";
    private static final String SELECTION_IMMEDIATE = "immediate";
    private static boolean mouseWasMoved;
    private final MovedMouseEventFilter windowMouseTracker = new MovedMouseEventFilter();
    private final MouseTimerDelegate timerDelegate = new MouseTimerDelegate();

    private static void migrateSelectionPropertiesFromLegacyMethod() {
        boolean shouldMigrateSelectionMethod;
        ResourceController rc = ResourceController.getResourceController();
        boolean bl = shouldMigrateSelectionMethod = rc.isPropertySetByUser("selection_method") && !rc.isPropertySetByUser(MOUSE_OVER_SELECTION);
        if (shouldMigrateSelectionMethod) {
            String selectionMethod = rc.getProperty("selection_method");
            NodeSelector.migrateSelectionSettingsFromSelectionMethod(rc, selectionMethod);
        }
    }

    private static void migrateSelectionSettingsFromSelectionMethod(ResourceController rc, String selectionMethod) {
        switch (selectionMethod) {
            case "selection_method_direct": {
                rc.setProperty(MOUSE_OVER_SELECTION, SELECTION_IMMEDIATE);
                break;
            }
            case "selection_method_delayed": {
                rc.setProperty(MOUSE_OVER_SELECTION, SELECTION_DELAYED);
                break;
            }
            case "selection_method_by_click": {
                rc.setProperty(MOUSE_OVER_SELECTION, SELECTION_DISABLED);
            }
        }
    }

    void createTimer(MouseEvent e) {
        if (!mouseWasMoved) {
            return;
        }
        if (!this.isInside(e)) {
            return;
        }
        String selectionTiming = this.getSelectionBehavior(e.getComponent());
        if (selectionTiming.equals(SELECTION_DISABLED)) {
            return;
        }
        if (selectionTiming.equals(SELECTION_IMMEDIATE)) {
            ActionListener action = this.createDelayedAction(e);
            action.actionPerformed(new ActionEvent(this, 0, ""));
            return;
        }
        this.timerDelegate.createTimer(e, this);
    }

    protected boolean isInside(MouseEvent e) {
        return new Rectangle(0, 0, e.getComponent().getWidth(), e.getComponent().getHeight()).contains(e.getPoint());
    }

    public void stopTimerForDelayedSelection() {
        this.timerDelegate.stopTimer();
    }

    @Override
    public ActionListener createDelayedAction(MouseEvent e) {
        return new TimeDelayedSelection(e);
    }

    @Override
    public boolean isActionEnabled(MouseEvent e) {
        String selectionBehavior = this.getSelectionBehavior(e.getComponent());
        return !selectionBehavior.equals(SELECTION_DISABLED);
    }

    boolean shouldSelectOnClick(MouseEvent e) {
        if (this.isInside(e)) {
            NodeView nodeView = this.getRelatedNodeView(e);
            return !nodeView.isSelected() || Controller.getCurrentController().getSelection().size() != 1;
        }
        return false;
    }

    void extendSelection(MouseEvent e, boolean scrollNodeTree) {
        Controller controller = Controller.getCurrentController();
        NodeView nodeView = this.getRelatedNodeView(e);
        NodeModel newlySelectedNode = nodeView.getNode();
        boolean extend = Compat.isMacOsX() ? e.isMetaDown() : e.isControlDown();
        boolean range = e.isShiftDown();
        IMapSelection selection = controller.getSelection();
        if (range && !extend) {
            selection.selectContinuous(newlySelectedNode);
        } else if (extend && !range) {
            selection.toggleSelected(newlySelectedNode);
        }
        if (extend == range) {
            if (!selection.isSelected(newlySelectedNode) || selection.size() != 1 || !(FocusManager.getCurrentManager().getFocusOwner() instanceof MainView)) {
                MouseEventActor.INSTANCE.withMouseEvent(() -> selection.selectAsTheOnlyOneSelected(newlySelectedNode));
                e.consume();
            }
            if (!extend && scrollNodeTree && !newlySelectedNode.isFolded()) {
                MouseEventActor.INSTANCE.withMouseEvent(() -> controller.getModeController().getMapController().scrollNodeTreeAfterSelect(newlySelectedNode));
                e.consume();
            }
        }
    }

    void selectSingleNode(MouseEvent e) {
        NodeView nodeV = this.getRelatedNodeView(e);
        Controller controller = Controller.getCurrentController();
        if (!((MapView)controller.getMapViewManager().getMapViewComponent()).isSelected(nodeV)) {
            MouseEventActor.INSTANCE.withMouseEvent(() -> controller.getSelection().selectAsTheOnlyOneSelected(nodeV.getNode()));
        }
    }

    public NodeView getRelatedNodeView(MouseEvent e) {
        return this.timerDelegate.getRelatedNodeView(e);
    }

    boolean isRelevant(MouseEvent e) {
        return this.windowMouseTracker.isRelevant(e);
    }

    void trackWindowForComponent(Component c) {
        this.windowMouseTracker.trackWindowForComponent(c);
        this.timerDelegate.trackWindowForComponent(c);
    }

    private String getSelectionBehavior(Component c) {
        String selectionInside;
        ResourceController rc = ResourceController.getResourceController();
        String behavior = rc.getProperty(MOUSE_OVER_SELECTION, SELECTION_IMMEDIATE);
        if (SELECTION_DISABLED.equals(behavior)) {
            return SELECTION_DISABLED;
        }
        if ("enabled".equals(behavior)) {
            behavior = SELECTION_IMMEDIATE;
            rc.setProperty(MOUSE_OVER_SELECTION, SELECTION_IMMEDIATE);
        }
        switch (selectionInside = rc.getProperty(MOUSE_OVER_SELECTION_INSIDE, SELECTION_INSIDE_SELECTED_MAP_VIEW)) {
            case "selection_inside.any_map": {
                return behavior;
            }
            case "selection_inside.selected_map_view": {
                MapView map = (MapView)SwingUtilities.getAncestorOfClass(MapView.class, c);
                return map != null && map.isSelected() ? behavior : SELECTION_DISABLED;
            }
            case "selection_inside.same_map": {
                MapView map = (MapView)SwingUtilities.getAncestorOfClass(MapView.class, c);
                if (map == null) {
                    return SELECTION_DISABLED;
                }
                IMapSelection selection = map.getModeController().getController().getSelection();
                return selection != null && map.getMap() == selection.getMap() ? behavior : SELECTION_DISABLED;
            }
            case "selection_inside.selected_window": {
                Window windowAncestor = SwingUtilities.getWindowAncestor(c);
                return windowAncestor != null && windowAncestor.isFocused() ? behavior : SELECTION_DISABLED;
            }
        }
        return SELECTION_DISABLED;
    }

    static {
        NodeSelector.migrateSelectionPropertiesFromLegacyMethod();
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){
            int lastX = -1;
            int lastY = -1;

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)event;
                    int x = mouseEvent.getXOnScreen();
                    int y = mouseEvent.getYOnScreen();
                    mouseWasMoved = this.lastX != x || this.lastY != y;
                    this.lastX = x;
                    this.lastY = y;
                }
            }
        }, 131120L);
        mouseWasMoved = false;
    }

    static class TimeDelayedSelection
    implements ActionListener {
        private final MouseEvent mouseEvent;

        TimeDelayedSelection(MouseEvent e) {
            this.mouseEvent = e;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (this.mouseEvent.getModifiers() != 0) {
                return;
            }
            try {
                Controller controller = Controller.getCurrentController();
                ModeController modeController = controller.getModeController();
                if (!modeController.isBlocked() && controller.getSelection().size() <= 1) {
                    NodeView nodeV = (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, this.mouseEvent.getComponent());
                    MapView map = nodeV.getMap();
                    if (nodeV.isDisplayable() && nodeV.getNode().hasVisibleContent(map.getFilter())) {
                        map.select();
                        NodeModel node = nodeV.getNode();
                        MouseEventActor.INSTANCE.withMouseEvent(() -> {
                            MapController mapController = modeController.getMapController();
                            controller.getSelection().selectAsTheOnlyOneSelected(node);
                            mapController.scrollNodeTreeAfterSelect(node);
                        });
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }
}

