---
stage: Create
group: Source Code
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Gitバージョン管理システムを操作します。
title: Gitをはじめよう
---

Gitとは、コードの変更を追跡し、他の人とコラボレーションするために使用するバージョンコントロールシステムです。GitLabは、CI/CDやその他の機能を提供し、ソフトウェア開発ライフサイクルを管理するのに役立つ、WebベースのGitリポジトリマネージャーです。

Gitを知らなくてもGitLabを使用できます。ただし、ソース管理にGitLabを使用する場合は、Gitを理解しておくと有利です。

Gitの学習は、より大きなワークフローの一部です。

![ワークフロー](img/get_started_git_v16_11.png)

## リポジトリ {#repositories}

Gitリポジトリとは、プロジェクトのすべてのファイル、フォルダー、およびバージョン履歴を含むディレクトリのことです。これは、Gitがコードへの変更を管理および追跡する中心的なハブとして機能します。

Gitリポジトリを初期化するか、既存のリポジトリを複製すると、Gitはプロジェクトディレクトリ内に非表示のディレクトリ`.git`を作成します。このディレクトリの構成内容は、Gitがリポジトリを管理するために使用するすべての重要なメタデータとオブジェクトで、ファイルに加えられたすべての変更の完全な履歴も含まれます。Gitはファイルレベルで変更を追跡するため、時間の経過に伴う個々のファイルへの変更を表示できます。

詳細については、[リポジトリ](../../user/project/repository/_index.md)を参照してください。

## 作業ディレクトリ {#working-directories}

作業ディレクトリとは、コードを変更する場所のことです。Gitリポジトリを複製すると、作業ディレクトリにリポジトリのローカルコピーが作成されます。ファイルを編集したり、新しいファイルを追加したり、コードをテストしたりできます。コラボレーションを行うには、以下を実行します。

- コミット: 作業ディレクトリで変更を加えた後、それらの変更をローカルリポジトリにコミットします。
- プッシュ: GitLabでホストされているリモートGitリポジトリに変更をプッシュします。これにより、他のチームメンバーが変更を利用できるようになります。
- プル: 他のユーザーによって行われた変更をリモートリポジトリからプルし、ローカルリポジトリが最新の変更で更新されていることを確認します。

詳細については、[一般的なGitコマンド](commands.md)を参照してください。

## ブランチ {#branches}

Gitでは、ブランチを使用して、互いの作業を妨げることなく、さまざまな機能、バグ修正、または実験に同時に取り組むことができます。ブランチを使用すると、デフォルトブランチに影響を与えることなく、変更を加えたりテストしたりできる隔離された環境を作成できます。GitLabでは、デフォルトブランチは通常`main`と呼ばれます。

### ブランチのマージ {#merge-a-branch}

機能が完了したか、バグが修正されたら、ブランチをデフォルトブランチにマージできます。これは、[マージリクエスト](../../user/project/merge_requests/_index.md)で行うことができます。マージは、変更の履歴を保持しながら、あるブランチから別のブランチに変更を安全に導入する方法です。

たとえば、両方のブランチで同じコード行を変更した場合など、ブランチ間に競合がある場合、GitLabはこれらを[マージコンフリクト](../../user/project/merge_requests/conflicts.md)としてフラグを立てます。これらは、コードをレビューおよび編集して手動で解決する必要があります。

### ブランチの削除 {#delete-a-branch}

マージが成功した後、不要になった場合はブランチを削除できます。不要なブランチを削除すると、リポジトリを整理して管理しやすくなります。

{{< alert type="note" >}}

作業が失われないように、最終マージ後にブランチを削除する前に、すべての変更がデフォルトブランチに組み込まれていることを検証してください。

{{< /alert >}}

詳細については、[ブランチ](../../user/project/repository/branches/_index.md)を参照してください。

## Gitワークフローを理解する {#understand-the-git-workflow}

コードを管理し、他のユーザーとコラボレーションし、Gitワークフローでプロジェクトを整理できます。標準的なGitワークフローには、次の手順が含まれます:

1. リポジトリのクローン: リポジトリをローカルマシンにクローンして、リポジトリのローカルコピーを作成します。元のリポジトリに影響を与えることなく、プロジェクトに取り組むことができます。
1. 新しいブランチを作成: 変更を加える前に、新しいブランチを作成することをお勧めします。これにより、変更が分離され、デフォルトブランチでの他のユーザーの作業が妨げられることはありません。
1. 変更を加える: 作業ディレクトリ内のファイルに変更を加えます。新しい機能を追加したり、バグを修正したり、その他の変更を加えたりすることができます。
1. 変更のステージ: ファイルを変更した後、コミットする変更をステージします。ステージングは、次のコミットに含める必要がある変更をGitに指示します。
1. 変更のコミット: ステージされた変更をローカルリポジトリにコミットします。コミットは作業のスナップショットを保存し、ファイルへの変更の履歴を作成します。
1. 変更のプッシュ: 変更を他のユーザーと共有するには、変更をリモートリポジトリにプッシュします。これにより、他のコラボレーターが変更を利用できるようになります。
1. ブランチのマージ: 変更がレビューされ、承認されたら、ブランチをデフォルトブランチにマージします。例: `main`。この手順では、変更がプロジェクトに組み込まれます。

## フォーク {#forks}

一部の組織、特にオープンソースプロジェクトに取り組んでいる組織では、異なるワークフローを使用する場合があります。たとえば、[フォーク](../../user/project/repository/forking_workflow.md)などです。

フォークとは、独自のネームスペースに存在するリポジトリの個人用コピーのことです。オープンソースプロジェクトにコントリビュートする場合、またはチームが集中型リポジトリを使用する場合は、このワークフローを使用します。

## Gitをインストールする {#install-git}

Gitコマンドを使用してGitLabプロジェクトにコントリビュートするには、コンピューターにGitクライアントをダウンロードしてインストールする必要があります。

インストールプロセスは、オペレーティングシステムによって異なります。たとえば、Windows、MacOS、またはLinuxです。Gitのインストール方法については、[Gitをインストール](how_to_install_git/_index.md)を参照してください。

## Gitコマンド {#git-commands}

コマンドラインからGitを操作するには、Gitコマンドを使用できます。

- `git clone`: リポジトリをローカルマシンにクローンします。
- `git branch`: ローカルリポジトリ内のブランチを一覧表示、作成、または削除します。
- `git checkout`: ローカルリポジトリ内の異なるブランチをスイッチします。
- `git add`: コミットの変更をステージングします。
- `git commit`: ステージされた変更をローカルリポジトリにコミットします。
- `git push`: ローカルコミットをリモートリポジトリにプッシュします。
- `git pull`: リモートリポジトリから変更をフェッチし、ローカルブランチにマージします。

より包括的な情報と詳細な説明については、[Gitコマンド](commands.md)ガイドを参照してください。

<!--- Use this section when the [Generate an SSH key pair](../user/ssh.md) page is added to the navigation

### Use SSH with Git

When you work with remote repositories, you should use SSH for secure communication.

GitLab uses the SSH protocol to securely communicate with Git.
When you use SSH keys to authenticate to the GitLab remote server,
you don't need to supply your username and password each time.

To learn how to generate and add SSH keys to your GitLab account,
see [Generate an SSH key pair](../user/ssh.md).
-->

## Gitを練習する {#practice-with-git}

Gitを学習する最良の方法は、練習することです。テストプロジェクトを作成し、さまざまなGitコマンドを実験して、さまざまなワークフローを調べることができます。

GitLabは、多くのGitオペレーションのためのウェブベースのインターフェースを提供しますが、コマンドラインからGitを使用してGitLabを操作することもできます。これにより、柔軟性と制御が向上します。

Gitコマンドのハンズオンアプローチについては、[チュートリアル: 最初のGitコミットを行う](../../tutorials/make_first_git_commit/_index.md)を参照してください。その他の役立つリソースについては、[チュートリアル: Gitについて学ぶ](../../tutorials/learn_git.md)を参照してください。
