/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Geodesic grayscale dilation of an image.


Geodesic dilation operates on a "marker" image and a "mask" image.
The marker image is dilated using an elementary structuring element
(neighborhood of radius one using only the face connected neighbors).
The resulting image is then compared with the mask image. The output
image is the pixelwise minimum of the dilated marker image and the
mask image.

Geodesic dilation is run either one iteration or until convergence. In
the convergence case, the filter is equivalent to "reconstruction by
dilation". This filter is implemented to handle both scenarios. The
one iteration case is multi-threaded. The convergence case is
delegated to another instance of the same filter (but configured to
run a single iteration).

The marker image must be less than or equal to the mask image (on a
pixel by pixel basis).

Geodesic morphology is described in Chapter 6 of Pierre Soille's book
"Morphological Image Analysis: Principles and Applications", Second
Edition, Springer, 2003.

A noniterative version of this algorithm can be found in the ReconstructionByDilationImageFilter . This noniterative solution is much faster than the implementation
provided here. All ITK filters that previously used GrayscaleGeodesicDilateImageFilter as part of their implementation have been converted to use the ReconstructionByDilationImageFilter . The GrayscaleGeodesicDilateImageFilter is maintained for backward compatibility.


See:
 MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter , ReconstructionByDilationImageFilter

 itk::simple::GrayscaleGeodesicDilate for the procedural interface

 itk::GrayscaleGeodesicDilateImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkGrayscaleGeodesicDilateImageFilter.h
*/
public class GrayscaleGeodesicDilateImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected GrayscaleGeodesicDilateImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.GrayscaleGeodesicDilateImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(GrayscaleGeodesicDilateImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(GrayscaleGeodesicDilateImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::GrayscaleGeodesicDilateImageFilter::~GrayscaleGeodesicDilateImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_GrayscaleGeodesicDilateImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::GrayscaleGeodesicDilateImageFilter::GrayscaleGeodesicDilateImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  GrayscaleGeodesicDilateImageFilter() {
    this(SimpleITKJNI.new_GrayscaleGeodesicDilateImageFilter(), true);
  }

  /**
Self&amp; itk::simple::GrayscaleGeodesicDilateImageFilter::SetRunOneIteration(bool RunOneIteration)

Set/Get whether the filter should run one iteration or until
convergence. When run to convergence, this filter is equivalent to
"reconstruction by dilation". Default is off.

*/
public  void setRunOneIteration(boolean RunOneIteration) {
    SimpleITKJNI.GrayscaleGeodesicDilateImageFilter_setRunOneIteration(swigCPtr, this, RunOneIteration);
  }

  /**
Self&amp; itk::simple::GrayscaleGeodesicDilateImageFilter::RunOneIterationOn()

Set the value of RunOneIteration to true or false respectfully.

*/
public  void runOneIterationOn() {
    SimpleITKJNI.GrayscaleGeodesicDilateImageFilter_runOneIterationOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GrayscaleGeodesicDilateImageFilter::RunOneIterationOff()
*/
public  void runOneIterationOff() {
    SimpleITKJNI.GrayscaleGeodesicDilateImageFilter_runOneIterationOff(swigCPtr, this);
  }

  /**
bool itk::simple::GrayscaleGeodesicDilateImageFilter::GetRunOneIteration() const

Set/Get whether the filter should run one iteration or until
convergence. When run to convergence, this filter is equivalent to
"reconstruction by dilation". Default is off.

*/
public  boolean getRunOneIteration() {
    return SimpleITKJNI.GrayscaleGeodesicDilateImageFilter_getRunOneIteration(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GrayscaleGeodesicDilateImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.GrayscaleGeodesicDilateImageFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::GrayscaleGeodesicDilateImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.GrayscaleGeodesicDilateImageFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GrayscaleGeodesicDilateImageFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.GrayscaleGeodesicDilateImageFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::GrayscaleGeodesicDilateImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.GrayscaleGeodesicDilateImageFilter_getFullyConnected(swigCPtr, this);
  }

  /**
std::string itk::simple::GrayscaleGeodesicDilateImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.GrayscaleGeodesicDilateImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::GrayscaleGeodesicDilateImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.GrayscaleGeodesicDilateImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::GrayscaleGeodesicDilateImageFilter::Execute(const Image &amp;image1, const Image &amp;image2)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2) {
    return new Image(SimpleITKJNI.GrayscaleGeodesicDilateImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

}
