/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Suppress local minima whose depth below the baseline is less than h.


HMinimaImageFilter suppresses local minima that are less than h intensity units below
the (local) background. This has the effect of smoothing over the
"low" parts of the noise in the image without smoothing over large
changes in intensity (region boundaries). See the HMaximaImageFilter to suppress the local maxima whose height is less than h intensity
units above the (local) background.

If original image is subtracted from the output of HMinimaImageFilter , the significant "valleys" in the image can be identified. This is
what the HConcaveImageFilter provides.

This filter uses the GrayscaleGeodesicErodeImageFilter . It provides its own input as the "mask" input to the geodesic
dilation. The "marker" image for the geodesic dilation is the input
image plus the height parameter h.

Geodesic morphology and the H-Minima algorithm is described in Chapter
6 of Pierre Soille's book "Morphological Image Analysis: Principles
and Applications", Second Edition, Springer, 2003.


See:
 GrayscaleGeodesicDilateImageFilter , HMinimaImageFilter , HConvexImageFilter

 MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter

 itk::simple::HMinima for the procedural interface

 itk::HMinimaImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkHMinimaImageFilter.h
*/
public class HMinimaImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected HMinimaImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.HMinimaImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(HMinimaImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(HMinimaImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::HMinimaImageFilter::~HMinimaImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_HMinimaImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::HMinimaImageFilter::HMinimaImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  HMinimaImageFilter() {
    this(SimpleITKJNI.new_HMinimaImageFilter(), true);
  }

  /**
Self&amp; itk::simple::HMinimaImageFilter::SetHeight(double Height)

Set/Get the height that a local maximum must be above the local
background (local contrast) in order to survive the processing. Local
maxima below this value are replaced with an estimate of the local
background.

*/
public  void setHeight(double Height) {
    SimpleITKJNI.HMinimaImageFilter_setHeight(swigCPtr, this, Height);
  }

  /**
double itk::simple::HMinimaImageFilter::GetHeight() const

Set/Get the height that a local maximum must be above the local
background (local contrast) in order to survive the processing. Local
maxima below this value are replaced with an estimate of the local
background.

*/
public  double getHeight() {
    return SimpleITKJNI.HMinimaImageFilter_getHeight(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::HMinimaImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.HMinimaImageFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::HMinimaImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.HMinimaImageFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::HMinimaImageFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.HMinimaImageFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::HMinimaImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.HMinimaImageFilter_getFullyConnected(swigCPtr, this);
  }

  /**
std::string itk::simple::HMinimaImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.HMinimaImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::HMinimaImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.HMinimaImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::HMinimaImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.HMinimaImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
