/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Apply a colormap to a label image.


Apply a colormap to a label image. The set of colors is a good
selection of distinct colors. The user can choose to use a background
value. In that case, a gray pixel with the same intensity than the
background label is produced.

This code was contributed in the Insight Journal paper: "The
watershed transform in ITK - discussion and new developments" by
Beare R., Lehmann G. https://doi.org/10.54294/lf8u75


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

Richard Beare. Department of Medicine, Monash University, Melbourne,
Australia.

See:
 LabelOverlayImageFilter

 LabelMapToRGBImageFilter , LabelToRGBFunctor, ScalarToRGBPixelFunctor

 itk::simple::LabelToRGB for the procedural interface

 itk::LabelToRGBImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkLabelToRGBImageFilter.h
*/
public class LabelToRGBImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected LabelToRGBImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.LabelToRGBImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(LabelToRGBImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(LabelToRGBImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::LabelToRGBImageFilter::~LabelToRGBImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_LabelToRGBImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::LabelToRGBImageFilter::LabelToRGBImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  LabelToRGBImageFilter() {
    this(SimpleITKJNI.new_LabelToRGBImageFilter(), true);
  }

  /**
Self&amp; itk::simple::LabelToRGBImageFilter::SetBackgroundValue(double BackgroundValue)

Set/Get the background value

*/
public  void setBackgroundValue(double BackgroundValue) {
    SimpleITKJNI.LabelToRGBImageFilter_setBackgroundValue(swigCPtr, this, BackgroundValue);
  }

  /**
double itk::simple::LabelToRGBImageFilter::GetBackgroundValue() const

Set/Get the background value

*/
public  double getBackgroundValue() {
    return SimpleITKJNI.LabelToRGBImageFilter_getBackgroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LabelToRGBImageFilter::SetColormap(std::vector&lt; uint8_t &gt; Colormap)
*/
public  void setColormap(VectorUInt8 Colormap) {
    SimpleITKJNI.LabelToRGBImageFilter_setColormap(swigCPtr, this, VectorUInt8.getCPtr(Colormap), Colormap);
  }

  /**
std::vector&lt;uint8_t&gt; itk::simple::LabelToRGBImageFilter::GetColormap() const
*/
public  VectorUInt8 getColormap() {
    return new VectorUInt8(SimpleITKJNI.LabelToRGBImageFilter_getColormap(swigCPtr, this), true);
  }

  /**
std::string itk::simple::LabelToRGBImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.LabelToRGBImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::LabelToRGBImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.LabelToRGBImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::LabelToRGBImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.LabelToRGBImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
