/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Applies a median filter to an image.


Computes an image where a given pixel is the median value of the the
pixels in a neighborhood about the corresponding input pixel.

A median filter is one of the family of nonlinear filters. It is used
to smooth an image without being biased by outliers or shot noise.

This filter requires that the input pixel type provides an operator&lt;() (LessThan Comparable).


See:
 Image

 Neighborhood

 NeighborhoodOperator

 NeighborhoodIterator

 itk::simple::Median for the procedural interface

 itk::MedianImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkMedianImageFilter.h
*/
public class MedianImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected MedianImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.MedianImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(MedianImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(MedianImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::MedianImageFilter::~MedianImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_MedianImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::MedianImageFilter::MedianImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  MedianImageFilter() {
    this(SimpleITKJNI.new_MedianImageFilter(), true);
  }

  /**
Self&amp; itk::simple::MedianImageFilter::SetRadius(unsigned int value)

Set the values of the Radius vector all to value

*/
public  void setRadius(VectorUInt32 Radius) {
    SimpleITKJNI.MedianImageFilter_setRadius__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(Radius), Radius);
  }

  /**
Self&amp; itk::simple::MedianImageFilter::SetRadius(unsigned int value)

Set the values of the Radius vector all to value

*/
public  void setRadius(long value) {
    SimpleITKJNI.MedianImageFilter_setRadius__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::MedianImageFilter::GetRadius() const
*/
public  VectorUInt32 getRadius() {
    return new VectorUInt32(SimpleITKJNI.MedianImageFilter_getRadius(swigCPtr, this), true);
  }

  /**
std::string itk::simple::MedianImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.MedianImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::MedianImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.MedianImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::MedianImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.MedianImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
