/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Applies a linear transformation to the intensity levels of the input Image .


RescaleIntensityImageFilter applies pixel-wise a linear transformation to the intensity values of
input image pixels. The linear transformation is defined by the user
in terms of the minimum and maximum values that the output image
should have.

The following equation gives the mapping of the intensity values


\\[ outputPixel = ( inputPixel - inputMin) \\cdot
\\frac{(outputMax - outputMin )}{(inputMax - inputMin)} + outputMin
\\]
 All computations are performed in the precision of the input pixel's
RealType. Before assigning the computed value to the output pixel.

NOTE: In this filter the minimum and maximum values of the input image
are computed internally using the MinimumMaximumImageCalculator . Users are not supposed to set those values in this filter. If you
need a filter where you can set the minimum and maximum values of the
input, please use the IntensityWindowingImageFilter . If you want a filter that can use a user-defined linear
transformation for the intensity, then please use the ShiftScaleImageFilter .


See:
 IntensityWindowingImageFilter

 itk::simple::RescaleIntensity for the procedural interface

 itk::RescaleIntensityImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkRescaleIntensityImageFilter.h
*/
public class RescaleIntensityImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected RescaleIntensityImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.RescaleIntensityImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(RescaleIntensityImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(RescaleIntensityImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::RescaleIntensityImageFilter::~RescaleIntensityImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_RescaleIntensityImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::RescaleIntensityImageFilter::RescaleIntensityImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  RescaleIntensityImageFilter() {
    this(SimpleITKJNI.new_RescaleIntensityImageFilter(), true);
  }

  /**
Self&amp; itk::simple::RescaleIntensityImageFilter::SetOutputMinimum(double OutputMinimum)
*/
public  void setOutputMinimum(double OutputMinimum) {
    SimpleITKJNI.RescaleIntensityImageFilter_setOutputMinimum(swigCPtr, this, OutputMinimum);
  }

  /**
double itk::simple::RescaleIntensityImageFilter::GetOutputMinimum() const
*/
public  double getOutputMinimum() {
    return SimpleITKJNI.RescaleIntensityImageFilter_getOutputMinimum(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::RescaleIntensityImageFilter::SetOutputMaximum(double OutputMaximum)
*/
public  void setOutputMaximum(double OutputMaximum) {
    SimpleITKJNI.RescaleIntensityImageFilter_setOutputMaximum(swigCPtr, this, OutputMaximum);
  }

  /**
double itk::simple::RescaleIntensityImageFilter::GetOutputMaximum() const
*/
public  double getOutputMaximum() {
    return SimpleITKJNI.RescaleIntensityImageFilter_getOutputMaximum(swigCPtr, this);
  }

  /**
std::string itk::simple::RescaleIntensityImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.RescaleIntensityImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::RescaleIntensityImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.RescaleIntensityImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::RescaleIntensityImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.RescaleIntensityImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
