/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Finds the threshold value of an image based on maximizing the number
of objects in the image that are larger than a given minimal size.



This method is based on Topological Stable State Thresholding to
calculate the threshold set point. This method is particularly
effective when there are a large number of objects in a microscopy
image. Compiling in Debug mode and enable the debug flag for this
filter to print debug information to see how the filter focuses in on
a threshold value. Please see the Insight Journal's MICCAI 2005
workshop for a complete description. References are below.
Parameters
The MinimumObjectSizeInPixels parameter is controlled through the
class Get/SetMinimumObjectSizeInPixels() method. Similar to the
standard itk::BinaryThresholdImageFilter the Get/SetInside and Get/SetOutside values of the threshold can be
set. The GetNumberOfObjects() and GetThresholdValue() methods return
the number of objects above the minimum pixel size and the calculated
threshold value.
Automatic Thresholding in ITK
There are multiple methods to automatically calculate the threshold
intensity value of an image. As of version 4.0, ITK has a Thresholding
( ITKThresholding ) module which contains numerous automatic
thresholding methods.implements two of these. Topological Stable State
Thresholding works well on images with a large number of objects to be
counted.
References:
1) Urish KL, August J, Huard J. "Unsupervised segmentation for
myofiber counting in immunofluorescent microscopy images". Insight
Journal. ISC/NA-MIC/MICCAI Workshop on Open-Source Software (2005) https://doi.org/10.54294/h1vbsl 2) Pikaz A, Averbuch, A. "Digital image thresholding based on
topological stable-state". Pattern Recognition, 29(5): 829-843, 1996.

Questions: email Ken Urish at ken.urish(at)gmail.com Please cc the itk
list serve for archival purposes.

See:
 itk::simple::ThresholdMaximumConnectedComponents for the procedural interface

 itk::ThresholdMaximumConnectedComponentsImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkThresholdMaximumConnectedComponentsImageFilter.h
*/
public class ThresholdMaximumConnectedComponentsImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ThresholdMaximumConnectedComponentsImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ThresholdMaximumConnectedComponentsImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ThresholdMaximumConnectedComponentsImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ThresholdMaximumConnectedComponentsImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ThresholdMaximumConnectedComponentsImageFilter::~ThresholdMaximumConnectedComponentsImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ThresholdMaximumConnectedComponentsImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ThresholdMaximumConnectedComponentsImageFilter::ThresholdMaximumConnectedComponentsImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ThresholdMaximumConnectedComponentsImageFilter() {
    this(SimpleITKJNI.new_ThresholdMaximumConnectedComponentsImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ThresholdMaximumConnectedComponentsImageFilter::SetMinimumObjectSizeInPixels(uint32_t MinimumObjectSizeInPixels)

The pixel type must support comparison operators. Set the minimum
pixel area used to count objects on the image. Thus, only objects that
have a pixel area greater than the minimum pixel area will be counted
as an object in the optimization portion of this filter. Essentially,
it eliminates noise from being counted as an object. The default value
is zero.

*/
public  void setMinimumObjectSizeInPixels(long MinimumObjectSizeInPixels) {
    SimpleITKJNI.ThresholdMaximumConnectedComponentsImageFilter_setMinimumObjectSizeInPixels(swigCPtr, this, MinimumObjectSizeInPixels);
  }

  /**
uint32_t itk::simple::ThresholdMaximumConnectedComponentsImageFilter::GetMinimumObjectSizeInPixels() const

The pixel type must support comparison operators. Set the minimum
pixel area used to count objects on the image. Thus, only objects that
have a pixel area greater than the minimum pixel area will be counted
as an object in the optimization portion of this filter. Essentially,
it eliminates noise from being counted as an object. The default value
is zero.

*/
public  long getMinimumObjectSizeInPixels() {
    return SimpleITKJNI.ThresholdMaximumConnectedComponentsImageFilter_getMinimumObjectSizeInPixels(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ThresholdMaximumConnectedComponentsImageFilter::SetUpperBoundary(double UpperBoundary)

The following Set/Get methods are for the binary threshold function.
This class automatically calculates the lower threshold boundary. The
upper threshold boundary, inside value, and outside value can be
defined by the user, however the standard values are used as default
if not set by the user. The default value of the: Inside value is the
maximum pixel type intensity. Outside value is the minimum pixel type
intensity. Upper threshold boundary is the maximum pixel type
intensity.

*/
public  void setUpperBoundary(double UpperBoundary) {
    SimpleITKJNI.ThresholdMaximumConnectedComponentsImageFilter_setUpperBoundary(swigCPtr, this, UpperBoundary);
  }

  /**
double itk::simple::ThresholdMaximumConnectedComponentsImageFilter::GetUpperBoundary() const

The following Set/Get methods are for the binary threshold function.
This class automatically calculates the lower threshold boundary. The
upper threshold boundary, inside value, and outside value can be
defined by the user, however the standard values are used as default
if not set by the user. The default value of the: Inside value is the
maximum pixel type intensity. Outside value is the minimum pixel type
intensity. Upper threshold boundary is the maximum pixel type
intensity.

*/
public  double getUpperBoundary() {
    return SimpleITKJNI.ThresholdMaximumConnectedComponentsImageFilter_getUpperBoundary(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ThresholdMaximumConnectedComponentsImageFilter::SetInsideValue(uint8_t InsideValue)

The following Set/Get methods are for the binary threshold function.
This class automatically calculates the lower threshold boundary. The
upper threshold boundary, inside value, and outside value can be
defined by the user, however the standard values are used as default
if not set by the user. The default value of the: Inside value is the
maximum pixel type intensity. Outside value is the minimum pixel type
intensity. Upper threshold boundary is the maximum pixel type
intensity.

*/
public  void setInsideValue(short InsideValue) {
    SimpleITKJNI.ThresholdMaximumConnectedComponentsImageFilter_setInsideValue(swigCPtr, this, InsideValue);
  }

  /**
uint8_t itk::simple::ThresholdMaximumConnectedComponentsImageFilter::GetInsideValue() const

The following Set/Get methods are for the binary threshold function.
This class automatically calculates the lower threshold boundary. The
upper threshold boundary, inside value, and outside value can be
defined by the user, however the standard values are used as default
if not set by the user. The default value of the: Inside value is the
maximum pixel type intensity. Outside value is the minimum pixel type
intensity. Upper threshold boundary is the maximum pixel type
intensity.

*/
public  short getInsideValue() {
    return SimpleITKJNI.ThresholdMaximumConnectedComponentsImageFilter_getInsideValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ThresholdMaximumConnectedComponentsImageFilter::SetOutsideValue(uint8_t OutsideValue)

The following Set/Get methods are for the binary threshold function.
This class automatically calculates the lower threshold boundary. The
upper threshold boundary, inside value, and outside value can be
defined by the user, however the standard values are used as default
if not set by the user. The default value of the: Inside value is the
maximum pixel type intensity. Outside value is the minimum pixel type
intensity. Upper threshold boundary is the maximum pixel type
intensity.

*/
public  void setOutsideValue(short OutsideValue) {
    SimpleITKJNI.ThresholdMaximumConnectedComponentsImageFilter_setOutsideValue(swigCPtr, this, OutsideValue);
  }

  /**
uint8_t itk::simple::ThresholdMaximumConnectedComponentsImageFilter::GetOutsideValue() const

The following Set/Get methods are for the binary threshold function.
This class automatically calculates the lower threshold boundary. The
upper threshold boundary, inside value, and outside value can be
defined by the user, however the standard values are used as default
if not set by the user. The default value of the: Inside value is the
maximum pixel type intensity. Outside value is the minimum pixel type
intensity. Upper threshold boundary is the maximum pixel type
intensity.

*/
public  short getOutsideValue() {
    return SimpleITKJNI.ThresholdMaximumConnectedComponentsImageFilter_getOutsideValue(swigCPtr, this);
  }

  /**
std::string itk::simple::ThresholdMaximumConnectedComponentsImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ThresholdMaximumConnectedComponentsImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ThresholdMaximumConnectedComponentsImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ThresholdMaximumConnectedComponentsImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ThresholdMaximumConnectedComponentsImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.ThresholdMaximumConnectedComponentsImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
