/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.ConstantPool;
import sun.jvm.hotspot.oops.ConstantPoolCacheEntry;
import sun.jvm.hotspot.oops.Metadata;
import sun.jvm.hotspot.oops.MetadataField;
import sun.jvm.hotspot.oops.MetadataVisitor;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class ConstantPoolCache
extends Metadata {
    private static MetadataField constants;
    private static long baseOffset;
    private static long elementSize;
    private static CIntField length;
    private static long intSize;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("ConstantPoolCache");
        constants = new MetadataField(type.getAddressField("_constant_pool"), 0L);
        baseOffset = type.getSize();
        Type elType = db.lookupType("ConstantPoolCacheEntry");
        elementSize = elType.getSize();
        length = new CIntField(type.getCIntegerField("_length"), 0L);
        intSize = VM.getVM().getObjectHeap().getIntSize();
    }

    public ConstantPoolCache(Address addr) {
        super(addr);
    }

    public boolean isConstantPoolCache() {
        return true;
    }

    public ConstantPool getConstants() {
        return (ConstantPool)constants.getValue(this);
    }

    public long getSize() {
        return Oop.alignObjectSize(baseOffset + (long)this.getLength() * elementSize);
    }

    public ConstantPoolCacheEntry getEntryAt(int i) {
        if (i < 0 || i >= this.getLength()) {
            throw new IndexOutOfBoundsException(i + " " + this.getLength());
        }
        return new ConstantPoolCacheEntry(this, i);
    }

    public int getIntAt(int entry, int fld) {
        long offset = baseOffset + (long)entry * elementSize + (long)fld * intSize;
        return (int)this.getAddress().getCIntegerAt(offset, intSize, true);
    }

    @Override
    public void printValueOn(PrintStream tty) {
        tty.print("ConstantPoolCache for " + this.getConstants().getPoolHolder().getName().asString() + " address = " + this.getAddress() + " offset = " + baseOffset);
    }

    public int getLength() {
        return (int)length.getValue(this.getAddress());
    }

    @Override
    public void iterateFields(MetadataVisitor visitor) {
        super.iterateFields(visitor);
        visitor.doMetadata(constants, true);
        for (int i = 0; i < this.getLength(); ++i) {
            ConstantPoolCacheEntry entry = this.getEntryAt(i);
            entry.iterateFields(visitor);
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                ConstantPoolCache.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

