/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.block;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;

public class BlockDiskElementDescriptor<K>
implements Serializable,
Externalizable {
    private static final long serialVersionUID = -1400659301208101411L;
    private K key;
    private int[] blocks;

    public BlockDiskElementDescriptor() {
    }

    public BlockDiskElementDescriptor(K key, int[] blocks) {
        this.key = key;
        this.blocks = blocks;
    }

    public void setKey(K key) {
        this.key = key;
    }

    public K getKey() {
        return this.key;
    }

    public void setBlocks(int[] blocks) {
        this.blocks = blocks;
    }

    public int[] getBlocks() {
        return this.blocks;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\nBlockDiskElementDescriptor");
        buf.append("\n key [" + this.getKey() + "]");
        buf.append("\n blocks [");
        if (this.getBlocks() != null) {
            Arrays.stream(this.getBlocks()).forEach(buf::append);
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.blocks = (int[])input.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeObject(this.blocks);
    }
}

