/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.lateral.socket.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.jcs3.auxiliary.lateral.LateralElementDescriptor;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;

public class LateralTCPSender {
    private static final Log log = LogManager.getLog(LateralTCPSender.class);
    private final int socketOpenTimeOut;
    private final int socketSoTimeOut;
    private final IElementSerializer serializer;
    private AsynchronousSocketChannel client;
    private int sendCnt;
    private final Lock lock = new ReentrantLock(true);

    @Deprecated
    public LateralTCPSender(ITCPLateralCacheAttributes lca) throws IOException {
        this(lca, new StandardSerializer());
    }

    public LateralTCPSender(ITCPLateralCacheAttributes lca, IElementSerializer serializer) throws IOException {
        this.socketOpenTimeOut = lca.getOpenTimeOut();
        this.socketSoTimeOut = lca.getSocketTimeOut();
        this.serializer = serializer;
        String p1 = lca.getTcpServer();
        if (p1 == null) {
            throw new IOException("Invalid server (null)");
        }
        int colonPosition = p1.lastIndexOf(58);
        if (colonPosition < 0) {
            throw new IOException("Invalid address [" + p1 + "]");
        }
        String h2 = p1.substring(0, colonPosition);
        int po = Integer.parseInt(p1.substring(colonPosition + 1));
        log.debug("h2 = {0}, po = {1}", h2, po);
        if (h2.isEmpty()) {
            throw new IOException("Cannot connect to invalid address [" + h2 + ":" + po + "]");
        }
        this.init(h2, po);
    }

    protected void init(String host, int port) throws IOException {
        log.info("Attempting connection to [{0}:{1}]", host, port);
        try {
            this.client = AsynchronousSocketChannel.open();
            InetSocketAddress hostAddress = new InetSocketAddress(host, port);
            Future<Void> future = this.client.connect(hostAddress);
            future.get(this.socketOpenTimeOut, TimeUnit.MILLISECONDS);
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException ioe) {
            throw new IOException("Cannot connect to " + host + ":" + port, ioe);
        }
    }

    public <K, V> void send(LateralElementDescriptor<K, V> led) throws IOException {
        ++this.sendCnt;
        if (log.isInfoEnabled() && this.sendCnt % 100 == 0) {
            log.info("Send Count {0} = {1}", this.client.getRemoteAddress(), this.sendCnt);
        }
        log.debug("sending LateralElementDescriptor");
        if (led == null) {
            return;
        }
        this.lock.lock();
        try {
            this.serializer.serializeTo(led, this.client, this.socketSoTimeOut);
        }
        finally {
            this.lock.unlock();
        }
    }

    public <K, V> Object sendAndReceive(LateralElementDescriptor<K, V> led) throws IOException {
        if (led == null) {
            return null;
        }
        Object response = null;
        this.lock.lock();
        try {
            this.send(led);
            response = this.serializer.deSerializeFrom(this.client, this.socketSoTimeOut, null);
        }
        catch (IOException | ClassNotFoundException ioe) {
            String message = "Could not open channel to " + this.client.getRemoteAddress() + " SoTimeout [" + this.socketSoTimeOut + "] Connected [" + this.client.isOpen() + "]";
            log.error(message, ioe);
            throw new IOException(message, ioe);
        }
        finally {
            this.lock.unlock();
        }
        return response;
    }

    public void dispose() throws IOException {
        log.info("Dispose called");
        this.client.close();
    }
}

