/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheConfigurator;
import org.apache.commons.jcs3.auxiliary.remote.RemoteUtils;
import org.apache.commons.jcs3.auxiliary.remote.behavior.IRemoteCacheConstants;
import org.apache.commons.jcs3.auxiliary.remote.server.RemoteCacheServer;
import org.apache.commons.jcs3.auxiliary.remote.server.RemoteCacheServerAttributes;
import org.apache.commons.jcs3.engine.behavior.ICacheServiceAdmin;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.config.OptionConverter;
import org.apache.commons.jcs3.utils.config.PropertySetter;
import org.apache.commons.jcs3.utils.threadpool.DaemonThreadFactory;

public class RemoteCacheServerFactory
implements IRemoteCacheConstants {
    private static final Log log = LogManager.getLog(RemoteCacheServerFactory.class);
    private static RemoteCacheServer<?, ?> remoteCacheServer;
    private static String serviceName;
    private static ScheduledExecutorService keepAliveDaemon;
    private static Registry registry;

    private RemoteCacheServerFactory() {
    }

    public static <K, V> RemoteCacheServer<K, V> getRemoteCacheServer() {
        return remoteCacheServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startup(String host, int port, Properties props) throws IOException {
        if (remoteCacheServer != null) {
            throw new IllegalArgumentException("Server already started.");
        }
        Class<RemoteCacheServer> clazz = RemoteCacheServer.class;
        synchronized (RemoteCacheServer.class) {
            if (remoteCacheServer != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            RemoteCacheServerAttributes rcsa = RemoteCacheServerFactory.configureRemoteCacheServerAttributes(props);
            rcsa.setRemoteLocation(Objects.toString(host, ""), port);
            log.info("Creating server with these attributes: {0}", rcsa);
            RemoteCacheServerFactory.setServiceName(rcsa.getRemoteServiceName());
            RMISocketFactory customRMISocketFactory = RemoteCacheServerFactory.configureObjectSpecificCustomFactory(props);
            RemoteUtils.configureGlobalCustomSocketFactory(rcsa.getRmiSocketFactoryTimeoutMillis());
            ICacheEventLogger cacheEventLogger = RemoteCacheServerFactory.configureCacheEventLogger(props);
            remoteCacheServer = customRMISocketFactory != null ? new RemoteCacheServer(rcsa, props, customRMISocketFactory) : new RemoteCacheServer(rcsa, props);
            remoteCacheServer.setCacheEventLogger(cacheEventLogger);
            registry = RemoteUtils.createRegistry(port);
            RemoteCacheServerFactory.registerServer(serviceName, remoteCacheServer);
            if (rcsa.isUseRegistryKeepAlive()) {
                if (keepAliveDaemon == null) {
                    keepAliveDaemon = Executors.newScheduledThreadPool(1, new DaemonThreadFactory("JCS-RemoteCacheServerFactory-"));
                }
                keepAliveDaemon.scheduleAtFixedRate(() -> RemoteCacheServerFactory.keepAlive(host, port, cacheEventLogger), 0L, rcsa.getRegistryKeepAliveDelayMillis(), TimeUnit.MILLISECONDS);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    protected static void keepAlive(String registryHost, int registryPort, ICacheEventLogger cacheEventLogger) {
        block9: {
            String message;
            block8: {
                String namingURL = RemoteUtils.getNamingURL(registryHost, registryPort, serviceName);
                log.debug("looking up server {0}", namingURL);
                try {
                    Remote obj = Naming.lookup(namingURL);
                    message = "RMI registry looks fine.  Found [" + obj + "] in registry [" + namingURL + "]";
                    if (cacheEventLogger != null) {
                        cacheEventLogger.logApplicationEvent("RegistryKeepAliveRunner", "Naming.lookup", message);
                    }
                    log.debug(message);
                }
                catch (Exception ex) {
                    message = "Problem finding server at [" + namingURL + "].  Will attempt to start registry and rebind.";
                    log.error(message, ex);
                    if (cacheEventLogger != null) {
                        cacheEventLogger.logError("RegistryKeepAliveRunner", "Naming.lookup", message + ":" + ex.getMessage());
                    }
                    registry = RemoteUtils.createRegistry(registryPort);
                    if (cacheEventLogger == null) break block8;
                    if (registry != null) {
                        cacheEventLogger.logApplicationEvent("RegistryKeepAliveRunner", "createRegistry", "Successfully created registry [" + serviceName + "].");
                    }
                    cacheEventLogger.logError("RegistryKeepAliveRunner", "createRegistry", "Could not start registry [" + serviceName + "].");
                }
            }
            try {
                RemoteCacheServerFactory.registerServer(serviceName, remoteCacheServer);
                String message2 = "Successfully rebound server to registry [" + serviceName + "].";
                if (cacheEventLogger != null) {
                    cacheEventLogger.logApplicationEvent("RegistryKeepAliveRunner", "registerServer", message2);
                }
                log.info(message2);
            }
            catch (RemoteException e) {
                message = "Could not rebind server to registry [" + serviceName + "].";
                log.error(message, e);
                if (cacheEventLogger == null) break block9;
                cacheEventLogger.logError("RegistryKeepAliveRunner", "registerServer", message + ":" + e.getMessage());
            }
        }
    }

    protected static ICacheEventLogger configureCacheEventLogger(Properties props) {
        return AuxiliaryCacheConfigurator.parseCacheEventLogger(props, "jcs.remotecache");
    }

    protected static RMISocketFactory configureObjectSpecificCustomFactory(Properties props) {
        RMISocketFactory customRMISocketFactory = OptionConverter.instantiateByKey(props, "jcs.remotecache.customrmisocketfactory", null);
        if (customRMISocketFactory != null) {
            PropertySetter.setProperties(customRMISocketFactory, props, "jcs.remotecache.customrmisocketfactory.");
            log.info("Will use server specific custom socket factory. {0}", customRMISocketFactory);
        } else {
            log.info("No server specific custom socket factory defined.");
        }
        return customRMISocketFactory;
    }

    protected static void registerServer(String serviceName, Remote server) throws RemoteException {
        if (server == null) {
            throw new RemoteException("Cannot register the server until it is created.");
        }
        if (registry == null) {
            throw new RemoteException("Cannot register the server: Registry is null.");
        }
        log.info("Binding server to {0}", serviceName);
        registry.rebind(serviceName, server);
    }

    protected static RemoteCacheServerAttributes configureRemoteCacheServerAttributes(Properties prop) {
        RemoteCacheServerAttributes rcsa = new RemoteCacheServerAttributes();
        PropertySetter.setProperties(rcsa, prop, "jcs.remotecache.serverattributes.");
        return rcsa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void shutdownImpl(String host, int port) throws IOException {
        Class<RemoteCacheServer> clazz = RemoteCacheServer.class;
        synchronized (RemoteCacheServer.class) {
            if (remoteCacheServer == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            log.info("Unbinding host={0}, port={1}, serviceName={2}", host, port, RemoteCacheServerFactory.getServiceName());
            try {
                Naming.unbind(RemoteUtils.getNamingURL(host, port, RemoteCacheServerFactory.getServiceName()));
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException(ex.getMessage() + "; host=" + host + ", port=" + port + ", serviceName=" + RemoteCacheServerFactory.getServiceName());
            }
            catch (NotBoundException notBoundException) {
                // empty catch block
            }
            remoteCacheServer.release();
            remoteCacheServer = null;
            if (keepAliveDaemon != null) {
                keepAliveDaemon.shutdownNow();
                keepAliveDaemon = null;
            }
            if (registry != null) {
                UnicastRemoteObject.unexportObject(registry, true);
                registry = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static void main(String[] args) throws Exception {
        String hostName;
        InetAddress host;
        ICacheServiceAdmin admin;
        int port;
        Properties prop = args.length > 0 ? RemoteUtils.loadProps(args[args.length - 1]) : new Properties();
        try {
            port = Integer.parseInt(prop.getProperty("registry.port"));
        }
        catch (NumberFormatException ex) {
            port = 1099;
        }
        if (args.length > 0 && args[0].toLowerCase().indexOf("-shutdown") != -1) {
            try {
                admin = RemoteCacheServerFactory.lookupCacheServiceAdmin(prop, port);
                admin.shutdown();
            }
            catch (Exception ex) {
                log.error("Problem calling shutdown.", ex);
            }
            log.debug("done.");
            System.exit(0);
        }
        if (args.length > 0 && args[0].toLowerCase().indexOf("-stats") != -1) {
            log.debug("getting cache stats");
            try {
                admin = RemoteCacheServerFactory.lookupCacheServiceAdmin(prop, port);
                try {
                    log.debug(admin.getStats());
                }
                catch (IOException es) {
                    log.error(es);
                }
            }
            catch (Exception ex) {
                log.error("Problem getting stats.", ex);
            }
            log.debug("done.");
            System.exit(0);
        }
        if ((host = InetAddress.getByName(hostName = prop.getProperty("registry.host"))).isLoopbackAddress()) {
            log.debug("main> creating registry on the localhost");
            RemoteUtils.createRegistry(port);
        }
        log.debug("main> starting up RemoteCacheServer");
        RemoteCacheServerFactory.startup(host.getHostName(), port, prop);
        log.debug("main> done");
    }

    private static ICacheServiceAdmin lookupCacheServiceAdmin(Properties config, int port) throws Exception {
        String remoteServiceName = config.getProperty("remote.cache.service.name", REMOTE_CACHE_SERVICE_VAL).trim();
        String registry = RemoteUtils.getNamingURL("", port, remoteServiceName);
        log.debug("looking up server {0}", registry);
        Remote obj = Naming.lookup(registry);
        log.debug("server found");
        return (ICacheServiceAdmin)((Object)obj);
    }

    protected static void setServiceName(String serviceName) {
        RemoteCacheServerFactory.serviceName = serviceName;
    }

    protected static String getServiceName() {
        return serviceName;
    }

    static {
        serviceName = IRemoteCacheConstants.REMOTE_CACHE_SERVICE_VAL;
    }
}

