/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.TransferHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.datatransfer.AbstractStackTransferHandler;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.datatransfer.importers.AbstractOsmDataPaster;
import org.openstreetmap.josm.gui.datatransfer.importers.FilePaster;
import org.openstreetmap.josm.gui.datatransfer.importers.OsmLinkPaster;
import org.openstreetmap.josm.gui.datatransfer.importers.PrimitiveDataPaster;
import org.openstreetmap.josm.gui.datatransfer.importers.PrimitiveTagTransferPaster;
import org.openstreetmap.josm.gui.datatransfer.importers.TagTransferPaster;
import org.openstreetmap.josm.gui.datatransfer.importers.TextTagPaster;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.Logging;

public class OsmTransferHandler
extends AbstractStackTransferHandler {
    private static final Collection<AbstractOsmDataPaster> SUPPORTED = Arrays.asList(new FilePaster(), new PrimitiveDataPaster(), new PrimitiveTagTransferPaster(), new TagTransferPaster(), new OsmLinkPaster(), new TextTagPaster());

    @Override
    protected Collection<AbstractOsmDataPaster> getSupportedPasters() {
        return Collections.unmodifiableCollection(SUPPORTED);
    }

    private boolean importTags(TransferHandler.TransferSupport support, Collection<? extends OsmPrimitive> primitives) {
        for (AbstractOsmDataPaster df : SUPPORTED) {
            if (!df.supports(support)) continue;
            try {
                if (!df.importTagsOn(support, primitives)) continue;
                return true;
            }
            catch (UnsupportedFlavorException | IOException e) {
                Logging.warn(e);
            }
        }
        return super.importData(support);
    }

    public void pasteOn(OsmDataLayer editLayer, EastNorth mPosition) {
        Transferable transferable = ClipboardUtils.getClipboardContent();
        this.pasteOn(editLayer, mPosition, transferable);
    }

    public void pasteOn(OsmDataLayer editLayer, EastNorth mPosition, Transferable transferable) {
        this.importData(new TransferHandler.TransferSupport((Component)MainApplication.getMainPanel(), transferable), editLayer, mPosition);
    }

    public void pasteTags(Collection<? extends OsmPrimitive> primitives) {
        Transferable transferable = ClipboardUtils.getClipboardContent();
        this.importTags(new TransferHandler.TransferSupport((Component)MainApplication.getMainPanel(), transferable), primitives);
    }

    public boolean isDataAvailable() {
        try {
            List<DataFlavor> available = Arrays.asList(ClipboardUtils.getClipboard().getAvailableDataFlavors());
            return SUPPORTED.stream().anyMatch(s -> s.supports(available));
        }
        catch (IllegalStateException e) {
            Logging.debug(e);
        }
        catch (NullPointerException e) {
            Logging.error(e);
        }
        return false;
    }
}

