/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metrics.impl.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.infinispan.commons.stat.CounterTracker;
import org.infinispan.commons.stat.MetricInfo;
import org.infinispan.commons.stat.TimerTracker;
import org.infinispan.distribution.Ownership;
import org.infinispan.metrics.impl.MetricUtils;

public class KeyMetrics<C> {
    private final EnumMap<Metric, KeyMetric> metrics = new EnumMap(Metric.class);

    public KeyMetrics() {
        Arrays.stream(Metric.values()).forEach(metric -> this.metrics.put((Metric)((Object)metric), new KeyMetric()));
    }

    public List<MetricInfo> getMetrics(boolean histograms, Function<C, KeyMetrics<C>> transformer, boolean skipOwnershipMetrics) {
        Metric[] values = Metric.values();
        ArrayList<MetricInfo> metrics = new ArrayList<MetricInfo>(values.length * 4);
        for (Metric v : values) {
            v.addMetricInfo(metrics, histograms, transformer, skipOwnershipMetrics);
        }
        return metrics;
    }

    public void recordMiss(long nanos) {
        this.recordWithoutOwnership(Metric.MISSES, nanos);
    }

    public void recordMiss(long nanos, Ownership ownership) {
        this.recordSingle(Metric.MISSES, nanos, ownership);
    }

    public void recordHit(long nanos) {
        this.recordWithoutOwnership(Metric.HITS, nanos);
    }

    public void recordHit(long nanos, Ownership ownership) {
        this.recordSingle(Metric.HITS, nanos, ownership);
    }

    public void recordStore(long nanos) {
        this.recordWithoutOwnership(Metric.STORES, nanos);
    }

    public void recordStore(long nanos, Ownership ownership) {
        this.recordSingle(Metric.STORES, nanos, ownership);
    }

    public void recordRemoveHit(long nanos) {
        this.recordWithoutOwnership(Metric.REMOVE_HITS, nanos);
    }

    public void recordRemoveHit(long nanos, Ownership ownership) {
        this.recordSingle(Metric.REMOVE_HITS, nanos, ownership);
    }

    public void recordRemoveMiss(long nanos) {
        this.recordWithoutOwnership(Metric.REMOVE_MISSES, nanos);
    }

    public void recordRemoveMiss(long nanos, Ownership ownership) {
        this.recordSingle(Metric.REMOVE_MISSES, nanos, ownership);
    }

    private void recordWithoutOwnership(Metric metric, long nanos) {
        this.metrics.get((Object)((Object)metric)).times.update(nanos, TimeUnit.NANOSECONDS);
    }

    private void recordSingle(Metric metric, long nanos, Ownership ownership) {
        KeyMetric m = this.metrics.get((Object)metric);
        m.times.update(nanos, TimeUnit.NANOSECONDS);
        switch (ownership) {
            case PRIMARY: {
                m.primaryOwner.increment();
                break;
            }
            case BACKUP: {
                m.backupOwner.increment();
                break;
            }
            case NON_OWNER: {
                m.nonOwner.increment();
            }
        }
    }

    private static enum Metric {
        HITS("Hit", "read hits"),
        MISSES("Miss", "read misses"),
        STORES("Store", "stores"),
        REMOVE_HITS("RemoveHit", "remove hits"),
        REMOVE_MISSES("RemoveMiss", "remove misses");

        final String name;
        final String description;

        private Metric(String name, String description) {
            this.name = name;
            this.description = description;
        }

        <C> void addMetricInfo(List<MetricInfo> metrics, boolean histograms, Function<C, KeyMetrics<C>> transformer, boolean skipOwnershipMetrics) {
            if (!skipOwnershipMetrics) {
                metrics.add((MetricInfo)MetricUtils.createCounter(this.name + "PrimaryOwner", "The number of single key " + this.description + " when this node is the primary owner", (o, t) -> {
                    ((KeyMetrics)transformer.apply(o)).metrics.get((Object)((Object)((Object)this))).primaryOwner = t;
                }, null));
                metrics.add((MetricInfo)MetricUtils.createCounter(this.name + "BackupOwner", "The number of single key " + this.description + " when this node is the backup owner", (o, t) -> {
                    ((KeyMetrics)transformer.apply(o)).metrics.get((Object)((Object)((Object)this))).backupOwner = t;
                }, null));
                metrics.add((MetricInfo)MetricUtils.createCounter(this.name + "NonOwner", "The number of single key " + this.description + " when this node is not an owner", (o, t) -> {
                    ((KeyMetrics)transformer.apply(o)).metrics.get((Object)((Object)((Object)this))).nonOwner = t;
                }, null));
            }
            if (histograms) {
                metrics.add((MetricInfo)MetricUtils.createTimer(this.name + "Times", "The " + this.description + " times", (o, t) -> {
                    ((KeyMetrics)transformer.apply(o)).metrics.get((Object)((Object)((Object)this))).times = t;
                }, null));
            } else {
                metrics.add((MetricInfo)MetricUtils.createFunctionTimer(this.name + "Times", "The " + this.description + " times", (o, t) -> {
                    ((KeyMetrics)transformer.apply(o)).metrics.get((Object)((Object)((Object)this))).times = t;
                }, null));
            }
        }
    }

    private static class KeyMetric {
        CounterTracker primaryOwner = CounterTracker.NO_OP;
        CounterTracker backupOwner = CounterTracker.NO_OP;
        CounterTracker nonOwner = CounterTracker.NO_OP;
        TimerTracker times = TimerTracker.NO_OP;

        private KeyMetric() {
        }
    }
}

