/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.ModelIO;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

public abstract class MapModelIO<T, V, A extends V, O extends V, AB, OB>
extends ModelIO<T, V, A, O, AB, OB> {
    protected MapModelIO(IOContext<V, A, O, AB, OB> context, DotName annotationName, DotName modelName) {
        super(context, annotationName, modelName);
    }

    protected T read(String key, AnnotationInstance annotation) {
        return this.read(annotation);
    }

    public Map<String, T> readMap(AnnotationTarget target) {
        return this.readMap((V)this.getRepeatableAnnotations(target));
    }

    public Map<String, T> readMap(AnnotationTarget target, Function<AnnotationInstance, Optional<String>> nameFn) {
        return this.readMap((O)this.getRepeatableAnnotations(target), (Function<O, T>)nameFn);
    }

    public Map<String, T> readMap(AnnotationInstance[] annotations) {
        return this.readMap((V)Arrays.asList(annotations));
    }

    public Map<String, T> readMap(AnnotationValue annotations) {
        return Optional.ofNullable(annotations).map(AnnotationValue::asNestedArray).map(this::readMap).orElse(null);
    }

    public Map<String, T> readMap(Collection<AnnotationInstance> annotations) {
        return this.readMap(annotations, this::getName, this::read);
    }

    public Map<String, T> readMap(Collection<AnnotationInstance> annotations, Function<AnnotationInstance, Optional<String>> nameFn) {
        return this.readMap(annotations, nameFn, this::read);
    }

    protected Map<String, T> readMap(Collection<AnnotationInstance> annotations, Function<AnnotationInstance, Optional<String>> nameFn, BiFunction<String, AnnotationInstance, T> reader) {
        if (annotations.isEmpty()) {
            return new LinkedHashMap(0);
        }
        IoLogging.logger.annotationsMap("@" + this.annotationName.local());
        return annotations.stream().map(annotation -> ((Optional)nameFn.apply((AnnotationInstance)annotation)).map(name -> MapModelIO.entry(name, reader.apply((String)name, (AnnotationInstance)annotation)))).filter(Optional::isPresent).map(Optional::get).collect(MapModelIO.toLinkedMap());
    }

    protected Map<String, T> readMap(O node, Function<O, T> reader) {
        return this.jsonIO().properties(node).stream().filter(property -> this.jsonIO().isObject(property.getValue())).map(property -> MapModelIO.entry((String)property.getKey(), reader.apply(this.jsonIO().asObject(property.getValue())))).collect(MapModelIO.toLinkedMap());
    }

    protected Map<String, T> readMap(O node, Predicate<String> nameFilter, Function<V, T> reader) {
        return this.jsonIO().properties(node).stream().filter(property -> nameFilter.test((String)property.getKey())).map(property -> MapModelIO.entry((String)property.getKey(), reader.apply(property.getValue()))).collect(MapModelIO.toLinkedMap());
    }

    public Map<String, T> readMap(V node) {
        return Optional.ofNullable(node).filter(this.jsonIO()::isObject).map(this.jsonIO()::asObject).map(this::readObjectMap).orElse(null);
    }

    public Map<String, T> readObjectMap(O node) {
        IoLogging.logger.jsonNodeMap(this.modelName.local());
        return this.readMap(node, this::readObject);
    }

    @Override
    public Optional<O> write(Map<String, T> models) {
        return this.optionalJsonObject(models).map(node -> {
            models.forEach((key, value) -> {
                Optional jsonValue = this.write(value);
                if (jsonValue.isPresent()) {
                    this.jsonIO().set(node, (String)key, jsonValue.get());
                } else {
                    this.jsonIO().set(node, (String)key, null);
                }
            });
            return node;
        }).map(this.jsonIO()::buildObject);
    }
}

