/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import org.wildfly.common.Assert;
import org.wildfly.common.array.Arrays2;
import org.wildfly.security.ssl.SSLConnectionInformation;

@FunctionalInterface
public interface SSLContextSelector {
    public static final SSLContextSelector NULL_SELECTOR = SSLContextSelector.constantSelector(null);

    public SSLContext selectContext(SSLConnectionInformation var1);

    public static SSLContextSelector aggregate(SSLContextSelector selector1, SSLContextSelector selector2) {
        return information -> {
            SSLContext sslContext = null;
            if (selector1 != null) {
                sslContext = selector1.selectContext(information);
            }
            if (sslContext == null && selector2 != null) {
                sslContext = selector2.selectContext(information);
            }
            return sslContext;
        };
    }

    public static SSLContextSelector aggregate(SSLContextSelector ... selectors) {
        Assert.checkNotNullParam((String)"selectors", (Object)selectors);
        SSLContextSelector[] clone = (SSLContextSelector[])Arrays2.compactNulls((Object[])((SSLContextSelector[])selectors.clone()));
        if (clone.length == 0) {
            return NULL_SELECTOR;
        }
        if (clone.length == 1) {
            return clone[0];
        }
        if (clone.length == 2) {
            return SSLContextSelector.aggregate(clone[0], clone[1]);
        }
        return name -> {
            for (SSLContextSelector selector : clone) {
                SSLContext sslContext = selector.selectContext(name);
                if (sslContext == null) continue;
                return sslContext;
            }
            return null;
        };
    }

    public static SSLContextSelector sniMatcherSelector(SNIMatcher matcher, SSLContext context) {
        Assert.checkNotNullParam((String)"matcher", (Object)matcher);
        Assert.checkNotNullParam((String)"context", (Object)context);
        return information -> {
            for (SNIServerName serverName : information.getSNIServerNames()) {
                if (serverName == null || serverName.getType() != matcher.getType() || !matcher.matches(serverName)) continue;
                return context;
            }
            return null;
        };
    }

    public static SSLContextSelector constantSelector(SSLContext context) {
        return name -> context;
    }
}

