/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.quarkus.hibernate.cache;

import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.infinispan.quarkus.hibernate.cache.AbstractDomainDataAccess;
import org.infinispan.quarkus.hibernate.cache.DomainDataRegionImpl;
import org.infinispan.quarkus.hibernate.cache.InternalDataAccess;

final class ReadOnlyEntityDataAccess
extends AbstractDomainDataAccess
implements EntityDataAccess {
    ReadOnlyEntityDataAccess(InternalDataAccess internal, DomainDataRegionImpl region) {
        super(internal, region);
    }

    public Object generateCacheKey(Object id, EntityPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return this.region.getCacheKeysFactory().createEntityKey(id, persister, factory, tenantIdentifier);
    }

    public Object getCacheKeyId(Object cacheKey) {
        return this.region.getCacheKeysFactory().getEntityId(cacheKey);
    }

    public boolean insert(SharedSessionContractImplementor session, Object key, Object value, Object version) {
        return this.internal.insert(session, key, value, version);
    }

    public boolean afterInsert(SharedSessionContractImplementor session, Object key, Object value, Object version) {
        return this.internal.afterInsert(session, key, value, version);
    }

    public boolean update(SharedSessionContractImplementor session, Object key, Object value, Object currentVersion, Object previousVersion) {
        throw new UnsupportedOperationException("Illegal attempt to edit read only item");
    }

    public boolean afterUpdate(SharedSessionContractImplementor session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) {
        throw new UnsupportedOperationException("Illegal attempt to edit read only item");
    }

    public AccessType getAccessType() {
        return AccessType.READ_ONLY;
    }
}

