/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Base64Url;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.services.Urls;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;
import org.keycloak.util.JsonSerialization;

public class SecureClientAuthenticationAssertionExecutor
implements ClientPolicyExecutorProvider<ClientPolicyExecutorConfigurationRepresentation> {
    private static final Logger logger = Logger.getLogger(SecureClientAuthenticationAssertionExecutor.class);
    private final KeycloakSession session;

    public SecureClientAuthenticationAssertionExecutor(KeycloakSession session) {
        this.session = session;
    }

    public String getProviderId() {
        return "secure-client-authentication-assertion";
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case PUSHED_AUTHORIZATION_REQUEST: 
            case TOKEN_REQUEST: 
            case TOKEN_REFRESH: 
            case TOKEN_INTROSPECT: 
            case TOKEN_REVOKE: {
                this.validateClientAssertion();
            }
        }
    }

    private void validateClientAssertion() throws ClientPolicyException {
        JsonWebToken token;
        KeycloakContext context = this.session.getContext();
        ClientModel client = context.getClient();
        if (client.isPublicClient()) {
            return;
        }
        MultivaluedMap params = context.getHttpRequest().getDecodedFormParameters();
        String clientAssertionType = (String)params.getFirst((Object)"client_assertion_type");
        String clientAssertion = (String)params.getFirst((Object)"client_assertion");
        if (clientAssertionType == null || clientAssertion == null || !clientAssertionType.equals("urn:ietf:params:oauth:client-assertion-type:jwt-bearer")) {
            return;
        }
        String[] parts = clientAssertion.split("\\.");
        if (parts.length < 2 || parts.length > 3) {
            logger.warn((Object)"client assertion format error");
            throw new ClientPolicyException("invalid_request", "invalid client assertion format");
        }
        String encodedContent = parts[1];
        byte[] content = Base64Url.decode((String)encodedContent);
        try {
            token = (JsonWebToken)JsonSerialization.readValue((byte[])content, JsonWebToken.class);
        }
        catch (IOException e) {
            logger.warnf("client assertion parse error: %s", (Object)e.getMessage());
            throw new ClientPolicyException("invalid_request", "invalid client assertion");
        }
        String issuerUrl = Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.session.getContext().getRealm().getName());
        ArrayList<String> expectedAudiences = new ArrayList<String>(Collections.singletonList(issuerUrl));
        if (token.getAudience() == null || token.getAudience().length != 1) {
            logger.warnf("invalid audience in client assertion - no audience or multiple audiences found", new Object[0]);
            throw new ClientPolicyException("invalid_request", "invalid audience in client assertion");
        }
        if (!token.hasAnyAudience(expectedAudiences)) {
            logger.warnf("invalid audience in client assertion - audience not issuer URL", new Object[0]);
            throw new ClientPolicyException("invalid_request", "invalid audience in client assertion");
        }
    }
}

