/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.util.ConcurrentSmallIntSet;
import org.infinispan.commons.util.EmptyIntSet;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.RangeSet;
import org.infinispan.commons.util.SingletonIntSet;
import org.infinispan.commons.util.SmallIntSet;
import org.infinispan.commons.util.Util;

public class IntSetsExternalization {
    private static final int RANGESET = 0;
    private static final int SMALLINTSET = 1;
    private static final int EMPTYSET = 2;
    private static final int SINGLETONSET = 3;
    private static final int CONCURRENTSET = 4;
    private static final Map<Class<?>, Integer> numbers = new HashMap(5);

    private IntSetsExternalization() {
    }

    public static void writeTo(ObjectOutput output, IntSet intSet) throws IOException {
        int number = numbers.getOrDefault(intSet.getClass(), -1);
        output.write(number);
        switch (number) {
            case 0: {
                UnsignedNumeric.writeUnsignedInt(output, intSet.size());
                break;
            }
            case 1: {
                SmallIntSet.writeTo(output, (SmallIntSet)intSet);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                UnsignedNumeric.writeUnsignedInt(output, ((SingletonIntSet)intSet).value);
                break;
            }
            case 4: {
                ConcurrentSmallIntSet.writeTo(output, (ConcurrentSmallIntSet)intSet);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported number: " + number);
            }
        }
    }

    public static IntSet readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        int magicNumber = input.readUnsignedByte();
        switch (magicNumber) {
            case 0: {
                return new RangeSet(UnsignedNumeric.readUnsignedInt(input));
            }
            case 1: {
                return SmallIntSet.readFrom(input);
            }
            case 2: {
                return EmptyIntSet.getInstance();
            }
            case 3: {
                return new SingletonIntSet(UnsignedNumeric.readUnsignedInt(input));
            }
            case 4: {
                return ConcurrentSmallIntSet.readFrom(input);
            }
        }
        throw new UnsupportedOperationException("Unsupported number: " + magicNumber);
    }

    public static Set<Class<? extends IntSet>> getTypeClasses() {
        return Util.asSet(SmallIntSet.class, RangeSet.class, RangeSet.class, EmptyIntSet.class, SingletonIntSet.class, ConcurrentSmallIntSet.class);
    }

    static {
        numbers.put(RangeSet.class, 0);
        numbers.put(RangeSet.class, 0);
        numbers.put(SmallIntSet.class, 1);
        numbers.put(EmptyIntSet.class, 2);
        numbers.put(SingletonIntSet.class, 3);
        numbers.put(ConcurrentSmallIntSet.class, 4);
    }
}

