/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.api;

import java.util.concurrent.CompletableFuture;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterListener;
import org.infinispan.counter.api.Handle;
import org.infinispan.counter.api.SyncStrongCounter;

public interface StrongCounter {
    public String getName();

    public CompletableFuture<Long> getValue();

    default public CompletableFuture<Long> incrementAndGet() {
        return this.addAndGet(1L);
    }

    default public CompletableFuture<Long> decrementAndGet() {
        return this.addAndGet(-1L);
    }

    public CompletableFuture<Long> addAndGet(long var1);

    public CompletableFuture<Void> reset();

    public <T extends CounterListener> Handle<T> addListener(T var1);

    default public CompletableFuture<Boolean> compareAndSet(long expect, long update) {
        return this.compareAndSwap(expect, update).thenApply(value -> value == expect);
    }

    public CompletableFuture<Long> compareAndSwap(long var1, long var3);

    public CounterConfiguration getConfiguration();

    public CompletableFuture<Void> remove();

    public SyncStrongCounter sync();

    public CompletableFuture<Long> getAndSet(long var1);
}

