/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration.cli.commands;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.keycloak.client.cli.config.ConfigData;
import org.keycloak.client.cli.util.ConfigUtil;
import org.keycloak.client.cli.util.HttpUtil;
import org.keycloak.client.cli.util.IoUtil;
import org.keycloak.client.cli.util.OsUtil;
import org.keycloak.client.registration.cli.KcRegMain;
import org.keycloak.client.registration.cli.commands.AbstractAuthOptionsCmd;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.util.JsonSerialization;
import picocli.CommandLine;

@CommandLine.Command(name="update-token", description={"CLIENT [ARGUMENTS]"})
public class UpdateTokenCmd
extends AbstractAuthOptionsCmd {
    @CommandLine.Parameters(arity="0..1")
    String clientId;

    @Override
    protected void process() {
        if (this.clientId == null) {
            throw new IllegalArgumentException("CLIENT not specified");
        }
        if (this.clientId.startsWith("-")) {
            IoUtil.warnfOut("You're using what looks like an OPTION as CLIENT: %s", this.clientId);
        }
        ConfigData config = ConfigUtil.loadConfig();
        config = this.copyWithServerInfo(config);
        this.setupTruststore(config);
        config = this.ensureAuthInfo(config);
        String auth = this.ensureToken(config);
        String cid = null;
        String server = config.getServerUrl();
        String realm = config.getRealm();
        InputStream response = HttpUtil.doGet(server + "/admin/realms/" + realm + "/clients", "application/json", "Bearer " + auth);
        try {
            List<ClientRepresentation> clients = JsonSerialization.readValue(response, new TypeReference<List<ClientRepresentation>>(){});
            for (ClientRepresentation client : clients) {
                if (!this.clientId.equals(client.getClientId())) continue;
                cid = client.getId();
                break;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to process response from server", e);
        }
        if (cid == null) {
            throw new RuntimeException("No client found for: " + this.clientId);
        }
        response = HttpUtil.doPost(server + "/admin/realms/" + realm + "/clients/" + cid + "/registration-access-token", "application/json", "application/json", null, "Bearer " + auth);
        try {
            ClientRepresentation client = JsonSerialization.readValue(response, ClientRepresentation.class);
            if (this.noconfig) {
                IoUtil.printOut(client.getRegistrationAccessToken());
            } else {
                ConfigUtil.saveMergeConfig(cfg -> ConfigUtil.setRegistrationToken(cfg.ensureRealmConfigData(server, realm), client.getClientId(), client.getRegistrationAccessToken()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to process response from server", e);
        }
    }

    @Override
    protected boolean nothingToDo() {
        return super.nothingToDo() && this.clientId == null;
    }

    @Override
    protected String help() {
        StringWriter sb = new StringWriter();
        PrintWriter out = new PrintWriter(sb);
        out.println("Usage: " + KcRegMain.CMD + " update-token CLIENT [ARGUMENTS]");
        out.println();
        out.println("Command to reissue, and set a new registration access token if an old one is lost or becomes invalid.");
        out.println("It requires an authenticated session using an account with administrator privileges.");
        this.globalOptions(out);
        out.println("    CLIENT                ClientId of the client to reissue a new Registration Access Token for");
        out.println("                          The new token is saved to a config file or printed to stdout if --no-config");
        out.println("                          (on-the-fly) authentication is used");
        out.println();
        out.println("Examples:");
        out.println();
        out.println("Request a new Registration Access Token from the server using current authenticated session:");
        out.println("  " + OsUtil.PROMPT + " " + KcRegMain.CMD + " update-token my_client");
        out.println();
        out.println("Use '" + KcRegMain.CMD + " help' for general information and a list of commands");
        return sb.toString();
    }
}

