/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class SupplierMap<K, V>
implements Map<K, V> {
    private final Map<K, Supplier<V>> suppliers = new HashMap<K, Supplier<V>>();
    private final Map<K, V> cache = new HashMap();

    @Override
    public void put(K key, Supplier<V> supplier) {
        this.suppliers.put(key, supplier);
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return null;
        }
        return (V)this.cache.computeIfAbsent(key, k -> {
            Supplier<V> supplier = this.suppliers.get(k);
            if (supplier == null) {
                return null;
            }
            return supplier.get();
        });
    }

    @Override
    public void clear() {
        this.suppliers.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.suppliers.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.suppliers.values().stream().map(Supplier::get).toList();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.suppliers.entrySet().stream().map(entry -> Map.entry(entry.getKey(), ((Supplier)entry.getValue()).get())).collect(Collectors.toSet());
    }

    @Override
    public int size() {
        return this.suppliers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.suppliers.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.suppliers.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V put(K key, V value) {
        Supplier<Object> old = this.suppliers.put(key, () -> value);
        if (old == null) {
            return null;
        }
        return (V)old.get();
    }

    @Override
    public V remove(Object key) {
        Supplier<V> remove = this.suppliers.remove(key);
        if (remove == null) {
            return null;
        }
        return remove.get();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.cache.put(entry.getKey(), entry.getValue());
        }
    }

    public Map<K, V> asEagerMap() {
        HashMap<K, V> result = new HashMap<K, V>();
        for (K key : this.suppliers.keySet()) {
            result.put(key, this.get(key));
        }
        return result;
    }
}

