/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev.filesystem;

import io.quarkus.deployment.dev.filesystem.QuarkusFileManager;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import org.jboss.logging.Logger;

public class StaticFileManager
extends QuarkusFileManager {
    private final QuarkusFileManager.Context context;
    private final AtomicBoolean once = new AtomicBoolean();

    public StaticFileManager(Supplier<StandardJavaFileManager> supplier, QuarkusFileManager.Context context) {
        super(supplier.get(), context);
        this.context = context;
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaSources(Iterable<? extends File> files) {
        return ((StandardJavaFileManager)this.fileManager).getJavaFileObjectsFromFiles(files);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        JavaFileObject file = ((StandardJavaFileManager)this.fileManager).getJavaFileForInput(location, className, kind);
        if (file != null && this.context.ignoreModuleInfo() && "CLASS_OUTPUT".equalsIgnoreCase(location.getName()) && "module-info".equalsIgnoreCase(className)) {
            if (this.once.compareAndSet(false, true)) {
                Logger.getLogger(StaticFileManager.class).info((Object)"Ignoring module-info.java in dev mode, set the `quarkus.live-reload.ignore-module-info` property to `false` in your project descriptor (`pom.xml` or `build.gradle`) to disable this behavior.");
            }
            return null;
        }
        return file;
    }
}

